/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.mixin;

import net.blazekrew.dirtlogic16x.logic.IDirtLogicIsValidLogic;
import net.blazekrew.dirtlogic16x.registry.IDirtLogicTagRegistry;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.blazekrew.variant16x.registry.TagRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.IPlantable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockMixin
implements IDirtLogicIsValidLogic {
    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=0)}, cancellable=true, remap=false)
    private void canSustainPlantCactus(BlockState state, IBlockReader world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.func_177230_c();
        if (TagRegistry.isInBlockTag(IDirtLogicTagRegistry.BlockTag.SAND, block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=2)}, cancellable=true, remap=false)
    private void canSustainPlantBush(BlockState state, IBlockReader world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.func_177230_c();
        if (this.isValidType(block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true, remap=false)
    private void canSustainPlantDesert(BlockState state, IBlockReader world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.func_177230_c();
        if ((TagRegistry.isInBlockTag(IDirtLogicTagRegistry.BlockTag.SAND, block) || BlockMixin.isTerracotta(block)) && !BlockMixin.isRedSand(block)) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    @Inject(method={"canSustainPlant"}, at={@At(value="RETURN", ordinal=9)}, cancellable=true, remap=false)
    private void canSustainPlantBeach(BlockState state, IBlockReader world, BlockPos position, Direction facing, IPlantable plantable, CallbackInfoReturnable<Boolean> info) {
        Block block = state.func_177230_c();
        boolean isBeach = TagRegistry.isInBlockTag(IDirtLogicTagRegistry.BlockTag.SAND, block) && !BlockMixin.isRedSand(block);
        boolean hasWater = false;
        if (world.func_180495_p(position.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(position.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(position.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(position.func_177968_d()).func_185904_a() == Material.field_151586_h) {
            hasWater = true;
        }
        if (isBeach && hasWater) {
            info.setReturnValue((Object)this.isOnValidState(state));
        }
    }

    private static boolean isRedSand(Block block) {
        return block == BlockRegistry.RED_SAND_SLAB || block == BlockRegistry.RED_SAND_STAIRS || block == BlockRegistry.RED_SAND_WALL;
    }

    private static boolean isTerracotta(Block block) {
        return block == BlockRegistry.TERRACOTTA_SLAB || block == BlockRegistry.TERRACOTTA_STAIRS || block == BlockRegistry.TERRACOTTA_WALL;
    }
}

