/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.block.addon;

import net.blazekrew.variant16x.block.addon.VariantFallingVerticalSlabBlock;
import net.blazekrew.variant16x.block.addon.VariantVerticalSlabBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class VariantConcretePowderVerticalSlabBlock
extends VariantFallingVerticalSlabBlock {
    private BlockState solidifiedState;

    public VariantConcretePowderVerticalSlabBlock(Block concreteBlock, Block.Properties properties) {
        super(properties);
        this.solidifiedState = concreteBlock.func_176223_P();
    }

    @Override
    public void onEndFalling(World world, BlockPos position, BlockState fallingState, BlockState hitState) {
        if (VariantConcretePowderVerticalSlabBlock.func_230137_b_((IBlockReader)world, position, hitState)) {
            world.func_180501_a(position, (BlockState)((BlockState)this.solidifiedState.func_206870_a((IProperty)TYPE, fallingState.func_177229_b((IProperty)TYPE))).func_206870_a((IProperty)WATERLOGGED, fallingState.func_177229_b((IProperty)WATERLOGGED)), 3);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state;
        BlockPos position;
        World world = context.func_195991_k();
        if (VariantConcretePowderVerticalSlabBlock.func_230137_b_((IBlockReader)world, position = context.func_195995_a(), state = world.func_180495_p(position))) {
            if (state.func_177230_c() == this.solidifiedState.func_177230_c()) {
                return (BlockState)((BlockState)state.func_206870_a((IProperty)TYPE, (Comparable)((Object)VariantVerticalSlabBlock.VariantVerticalSlabType.DOUBLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            IFluidState fluidState = world.func_204610_c(position);
            BlockState blockState = (BlockState)this.solidifiedState.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
            Direction direction = this.getDirectionForPlacement(context);
            VariantVerticalSlabBlock.VariantVerticalSlabType type = VariantVerticalSlabBlock.VariantVerticalSlabType.getType(direction);
            return (BlockState)blockState.func_206870_a((IProperty)TYPE, (Comparable)((Object)type));
        }
        return super.func_196258_a(context);
    }

    private static boolean func_230137_b_(IBlockReader world, BlockPos position, BlockState state) {
        return VariantConcretePowderVerticalSlabBlock.causesSolidify(state) || VariantConcretePowderVerticalSlabBlock.isTouchingLiquid(world, position);
    }

    private static boolean isTouchingLiquid(IBlockReader world, BlockPos position) {
        boolean flag = false;
        BlockPos.Mutable position$mutable = new BlockPos.Mutable(position);
        for (Direction direction : Direction.values()) {
            BlockState state = world.func_180495_p((BlockPos)position$mutable);
            if (direction == Direction.DOWN && !VariantConcretePowderVerticalSlabBlock.causesSolidify(state)) continue;
            position$mutable.func_189533_g((Vec3i)position).func_189536_c(direction);
            state = world.func_180495_p((BlockPos)position$mutable);
            if (!VariantConcretePowderVerticalSlabBlock.causesSolidify(state) || state.func_224755_d(world, position, direction.func_176734_d())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean causesSolidify(BlockState state) {
        return state.func_204520_s().func_206884_a(FluidTags.field_206959_a);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos position, BlockPos facingPosition) {
        if (VariantConcretePowderVerticalSlabBlock.isTouchingLiquid((IBlockReader)world, position)) {
            return (BlockState)((BlockState)this.solidifiedState.func_206870_a((IProperty)TYPE, state.func_177229_b((IProperty)TYPE))).func_206870_a((IProperty)WATERLOGGED, state.func_177229_b((IProperty)WATERLOGGED));
        }
        return super.func_196271_a(state, facing, facingState, world, position, facingPosition);
    }
}

