/*
 * Decompiled with CFR 0.152.
 */
package com.vanyabaou.arspmmo;

import com.vanyabaou.arspmmo.Config;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="arspmmo")
public class PMMOEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleAttack(LivingAttackEvent event) {
        ServerPlayerEntity player;
        if (!((Boolean)Config.PMMO_ATTACK_HANDLER.get()).booleanValue()) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        Entity source = event.getSource().func_76346_g();
        if (target != null && source instanceof ServerPlayerEntity && XP.isPlayerSurvival((PlayerEntity)(player = (ServerPlayerEntity)source))) {
            String skill;
            ItemStack mainItemStack = player.func_184614_ca();
            ResourceLocation mainResLoc = player.func_184614_ca().func_77973_b().getRegistryName();
            ResourceLocation offResLoc = player.func_184592_cb().func_77973_b().getRegistryName();
            Map weaponReq = XP.getXpBypass((ResourceLocation)mainResLoc, (JType)JType.REQ_WEAPON);
            NBTHelper.maxDoubleMaps((Map)weaponReq, (Map)XP.getXpBypass((ResourceLocation)offResLoc, (JType)JType.REQ_WEAPON));
            String itemSpecificSkill = AutoValues.getItemSpecificSkill((String)mainResLoc.toString());
            boolean swordInMainHand = mainItemStack.func_77973_b() instanceof SwordItem;
            if (itemSpecificSkill != null) {
                skill = itemSpecificSkill;
            } else if (event.getSource().field_76373_n.equals("arrow")) {
                skill = Skill.ARCHERY.toString();
            } else {
                skill = Skill.COMBAT.toString();
                double d = Util.getDistance((Vector3d)player.func_213303_ch(), (Vector3d)target.func_213303_ch());
                double d2 = 4.2 + (double)target.func_213311_cf();
                double d3 = swordInMainHand ? 1.523 : 0.0;
                if (d > d2 + d3) {
                    skill = Skill.MAGIC.toString();
                }
            }
            if (harmonised.pmmo.config.Config.getConfig((String)"weaponReqEnabled") != 0.0) {
                int enchantGap;
                int weaponGap;
                int gap;
                if (harmonised.pmmo.config.Config.getConfig((String)"autoGenerateValuesEnabled") != 0.0 && harmonised.pmmo.config.Config.getConfig((String)"autoGenerateWeaponReqDynamicallyEnabled") != 0.0) {
                    weaponReq.put(skill, weaponReq.getOrDefault(skill, AutoValues.getWeaponReqFromStack((ItemStack)mainItemStack)));
                }
                if ((gap = Math.max(weaponGap = XP.getSkillReqGap((PlayerEntity)player, (Map)weaponReq), enchantGap = XP.getSkillReqGap((PlayerEntity)player, (Map)XP.getEnchantsUseReq((ItemStack)player.func_184614_ca())))) > 0) {
                    if (enchantGap < gap) {
                        NetworkHandler.sendToPlayer((MessageDoubleTranslation)new MessageDoubleTranslation("pmmo.notSkilledEnoughToUseAsWeapon", player.func_184614_ca().func_77977_a(), "", true, 2), (ServerPlayerEntity)player);
                    }
                    if (((Boolean)harmonised.pmmo.config.Config.forgeConfig.strictReqWeapon.get()).booleanValue()) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

