/*
 * Decompiled with CFR 0.152.
 */
package com.vanyabaou.arspmmo;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.items.SpellArrow;
import com.hollingsworth.arsnouveau.common.items.SpellBow;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.vanyabaou.arspmmo.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="arspmmo")
public class ArsEventHandler {
    @SubscribeEvent
    public static void onSpellCast(SpellCastEvent event) {
        Map<String, Object> spellData;
        boolean isSensitive;
        RayTraceResult result;
        if (event.getEntityLiving() == null) {
            return;
        }
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        UUID uuid = entity.func_110124_au();
        ServerPlayerEntity player = XP.getPlayerByUUID((UUID)uuid);
        if (player == null) {
            return;
        }
        if (player.func_184812_l_()) {
            return;
        }
        Spell spell = event.spell;
        boolean touchAir = false;
        AbstractCastMethod castMethod = spell.getCastMethod();
        if (!(!(castMethod instanceof MethodTouch) || (result = player.func_213324_a(5.0, 0.0f, isSensitive = spell.getBuffsAtIndex(0, (LivingEntity)player, (AbstractAugment)AugmentSensitive.INSTANCE) > 0)).func_216346_c() == RayTraceResult.Type.BLOCK || isSensitive && result instanceof BlockRayTraceResult)) {
            touchAir = true;
        }
        if (!((Boolean)(spellData = ArsEventHandler.checkRecipe((PlayerEntity)player, spell.recipe.toArray(new AbstractSpellPart[0]))).get("canCast")).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("arspmmo.notSkilledEnoughToCastSpell", new Object[]{new TranslationTextComponent(((AbstractSpellPart)spellData.get("glyph")).getLocalizationKey())}).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.RED)), true);
            event.setCanceled(true);
            return;
        }
        if (((Boolean)spellData.get("hasEffect")).booleanValue() && !touchAir) {
            double xpAward = (Double)Config.XP_BONUS.get() * (double)spell.getCastingCost();
            XP.awardXp((ServerPlayerEntity)player, (String)"magic", null, (double)xpAward, (boolean)false, (boolean)false, (boolean)false);
        }
    }

    @SubscribeEvent
    public static void calcMaxMana(MaxManaCalcEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        UUID uuid = entity.func_110124_au();
        double magicLevel = Skill.getLevel((String)"magic", (UUID)uuid);
        int maxMana = event.getMax();
        double manaBonus = 1.0 + magicLevel * (Double)Config.MAX_MANA_BONUS.get();
        event.setMax((int)((double)maxMana * manaBonus));
    }

    @SubscribeEvent
    public static void calcManaRegen(ManaRegenCalcEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        UUID uuid = entity.func_110124_au();
        double magicLevel = Skill.getLevel((String)"magic", (UUID)uuid);
        double regen = event.getRegen();
        double manaBonus = 1.0 + magicLevel * (Double)Config.MANA_REGEN_BONUS.get();
        event.setRegen(regen * manaBonus);
    }

    @SubscribeEvent
    public static void itemRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_77973_b() instanceof SpellBow) {
            PlayerEntity player = event.getPlayer();
            if (player.func_184812_l_()) {
                return;
            }
            SpellCaster caster = SpellCaster.deserialize((ItemStack)itemStack);
            SpellBow spellBow = (SpellBow)itemStack.func_77973_b();
            ItemStack arrowStack = spellBow.findAmmo(player, itemStack);
            if (!arrowStack.func_190926_b() && arrowStack.func_77973_b() instanceof SpellArrow) {
                SpellArrow spellArrow = (SpellArrow)arrowStack.func_77973_b();
                Map<String, Object> arrowSpellData = ArsEventHandler.checkRecipe(player, spellArrow.part);
                if (!((Boolean)arrowSpellData.get("canCast")).booleanValue()) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("arspmmo.notSkilledEnoughToCastSpell", new Object[]{new TranslationTextComponent(spellArrow.part.getLocalizationKey())}).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.RED)), true);
                    event.setCanceled(true);
                }
            }
            SpellResolver spellResolver = new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)player));
            Map<String, Object> spellData = ArsEventHandler.checkRecipe(player, spellResolver.spell.recipe.toArray(new AbstractSpellPart[0]));
            if (!((Boolean)spellData.get("canCast")).booleanValue()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("arspmmo.notSkilledEnoughToCastSpell", new Object[]{new TranslationTextComponent(((AbstractSpellPart)spellData.get("glyph")).getLocalizationKey())}).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.RED)), true);
                event.setCanceled(true);
            }
        }
    }

    private static Map<String, Object> checkRecipe(PlayerEntity player, AbstractSpellPart ... spellParts) {
        boolean hasEffect = false;
        HashMap<String, Object> spellData = new HashMap<String, Object>();
        for (AbstractSpellPart spellPart : spellParts) {
            if (spellPart instanceof AbstractEffect) {
                hasEffect = true;
            }
            if (!XP.isPlayerSurvival((PlayerEntity)player) || !((Boolean)harmonised.pmmo.config.Config.forgeConfig.useReqEnabled.get()).booleanValue()) continue;
            String glyphRegistryName = "ars_nouveau:" + spellPart.getItemID();
            boolean canCastTier = true;
            switch (spellPart.getTier().ordinal()) {
                case 0: {
                    if (XP.checkReq((PlayerEntity)player, (String)ItemsRegistry.noviceSpellBook.getRegistryName().toString(), (JType)JType.REQ_USE)) break;
                    canCastTier = false;
                    break;
                }
                case 1: {
                    if (XP.checkReq((PlayerEntity)player, (String)ItemsRegistry.apprenticeSpellBook.getRegistryName().toString(), (JType)JType.REQ_USE)) break;
                    canCastTier = false;
                    break;
                }
                case 2: {
                    if (XP.checkReq((PlayerEntity)player, (String)ItemsRegistry.archmageSpellBook.getRegistryName().toString(), (JType)JType.REQ_USE)) break;
                    canCastTier = false;
                    break;
                }
                default: {
                    canCastTier = false;
                }
            }
            if (!canCastTier) {
                spellData.put("canCast", false);
                spellData.put("glyph", spellPart);
                return spellData;
            }
            if (XP.checkReq((PlayerEntity)player, (String)glyphRegistryName, (JType)JType.REQ_USE)) continue;
            spellData.put("canCast", false);
            spellData.put("glyph", spellPart);
            return spellData;
        }
        spellData.put("canCast", true);
        spellData.put("hasEffect", hasEffect);
        return spellData;
    }
}

