/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class ProcessingRecipe
implements Recipe<Container> {
    protected final RecipeType<?> type;
    protected final Category category;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int time;

    public ProcessingRecipe(RecipeType<?> type, Category category, Ingredient ingredient, ItemStack result, int time) {
        this.type = type;
        this.category = category;
        this.ingredient = ingredient;
        this.result = result;
        this.time = time;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public Category getCategory() {
        return this.category;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.ingredient.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static <T extends ProcessingRecipe> Builder<T> builder(Factory<T> factory, Category category, Ingredient input, ItemStack output, int processTime) {
        return new Builder<T>(factory, category, input, output, processTime);
    }

    public static enum Category implements StringRepresentable
    {
        BLOCKS("blocks"),
        ITEMS("items"),
        FOOD("food"),
        MISC("misc");

        public static final StringRepresentable.EnumCodec<Category> CODEC;
        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130072_(this.name, 6);
        }

        public static Category fromNetwork(FriendlyByteBuf buf) {
            return Category.byName(buf.m_130136_(6));
        }

        public static Category byName(String name) {
            return (Category)CODEC.m_262792_(name, (Enum)MISC);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Category::values);
        }
    }

    public static class Builder<T extends ProcessingRecipe>
    implements RecipeBuilder {
        protected final Category category;
        protected final Factory<T> factory;
        protected final Ingredient input;
        protected final ItemStack output;
        protected final int processTime;
        protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        private Builder(Factory<T> factory, Category category, Ingredient input, ItemStack output, int processTime) {
            this.factory = factory;
            this.category = category;
            this.input = input;
            this.output = output;
            this.processTime = processTime;
        }

        public RecipeBuilder m_126132_(String s, Criterion<?> instance) {
            this.criteria.put(s, instance);
            return this;
        }

        public RecipeBuilder m_126145_(@Nullable String group) {
            throw new UnsupportedOperationException("Group not supported for ProcessingRecipes");
        }

        public net.minecraft.world.item.Item m_142372_() {
            return this.output.m_41720_();
        }

        public void m_126140_(RecipeOutput output, ResourceLocation id) {
            Advancement.Builder builder = output.m_293552_().m_138383_("has_the_recipe", RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(AdvancementRequirements.Strategy.f_291456_);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).m_138383_(arg_0, arg_1));
            output.m_292927_(id, this.factory.create(this.category, this.input, this.output, this.processTime), builder.m_138403_(id.m_246208_("recipes/" + this.category.m_7912_() + "/")));
        }
    }

    public static interface Factory<T extends ProcessingRecipe> {
        public T create(Category var1, Ingredient var2, ItemStack var3, int var4);
    }

    public static abstract class ItemWithCount
    extends ProcessingRecipe {
        public static final Codec<ItemStack> ITEMSTACK = RecordCodecBuilder.create(builder -> builder.group((App)BuiltInRegistries.f_257033_.m_206110_().fieldOf("item").forGetter(ItemStack::m_220173_), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::m_41613_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.m_41783_()))).apply((Applicative)builder, ItemStack::new));
        public static final Codec<ItemStack> RESULT = ExtraCodecs.m_144639_(ITEMSTACK, (Codec)ItemStack.f_302992_).xmap(either -> (ItemStack)either.map(Function.identity(), Function.identity()), stack -> stack.m_41613_() == 1 && stack.m_41783_() == null ? Either.right((Object)stack) : Either.left((Object)stack));

        public ItemWithCount(RecipeType<?> type, Category category, Ingredient ingredient, ItemStack result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements RecipeSerializer<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final Codec<T> codec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.create(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)Ingredient.f_290991_.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)RESULT.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
            }

            public Codec<T> m_292673_() {
                return this.codec;
            }

            public T fromNetwork(FriendlyByteBuf buf) {
                Category category = Category.fromNetwork(buf);
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
                ItemStack output = buf.m_130267_();
                int processTime = buf.m_130242_();
                return this.factory.create(category, input, output, processTime);
            }

            public void toNetwork(FriendlyByteBuf buf, T recipe) {
                ((ProcessingRecipe)recipe).category.toNetwork(buf);
                ((ProcessingRecipe)recipe).ingredient.m_43923_(buf);
                buf.m_130055_(((ProcessingRecipe)recipe).result);
                buf.m_130130_(((ProcessingRecipe)recipe).time);
            }
        }
    }

    public static abstract class Item
    extends ProcessingRecipe {
        public static final Codec<ItemStack> SINGLE_ITEMSTACK = RecordCodecBuilder.create(builder -> builder.group((App)BuiltInRegistries.f_257033_.m_206110_().fieldOf("item").forGetter(ItemStack::m_220173_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.m_41783_()))).apply((Applicative)builder, (holder, tag) -> new ItemStack(holder, 1, tag)));
        public static final Codec<ItemStack> RESULT = ExtraCodecs.m_144639_(SINGLE_ITEMSTACK, (Codec)ItemStack.f_302992_).xmap(either -> (ItemStack)either.map(Function.identity(), Function.identity()), stack -> stack.m_41783_() == null ? Either.right((Object)stack) : Either.left((Object)stack));

        public Item(RecipeType<?> type, Category category, Ingredient ingredient, ItemStack result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static ProcessingRecipe from(final AbstractCookingRecipe recipe, RegistryAccess access) {
            return new ProcessingRecipe(recipe.m_6671_(), Category.FOOD, (Ingredient)recipe.m_7527_().get(0), recipe.m_8043_(access), recipe.m_43753_()){

                public RecipeSerializer<?> m_7707_() {
                    return recipe.m_7707_();
                }
            };
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements RecipeSerializer<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final Codec<T> codec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.create(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)Ingredient.f_290991_.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)RESULT.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
            }

            public Codec<T> m_292673_() {
                return this.codec;
            }

            public T fromNetwork(FriendlyByteBuf buf) {
                Category category = Category.fromNetwork(buf);
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
                ItemStack output = buf.m_130267_();
                int processTime = buf.m_130242_();
                return this.factory.create(category, input, output, processTime);
            }

            public void toNetwork(FriendlyByteBuf buf, T recipe) {
                ((ProcessingRecipe)recipe).category.toNetwork(buf);
                ((ProcessingRecipe)recipe).ingredient.m_43923_(buf);
                buf.m_130055_(((ProcessingRecipe)recipe).result);
                buf.m_130130_(((ProcessingRecipe)recipe).time);
            }
        }
    }
}

