/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.jei;

import com.mrcrayfish.furniture.refurbished.client.gui.screen.ComputerScreen;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.CuttingBoardCombiningCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.CuttingBoardSlicingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FreezerSolidifyingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FryingPanCookingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.GrillCookingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.MicrowaveHeatingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.OvenBakingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.ToasterToastingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.WorkbenchConstructingCategory;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class Plugin
implements IModPlugin {
    public static final ResourceLocation TEXTURES = Utils.resource("textures/gui/jei.png");
    public static final ResourceLocation TEXTURES_2 = Utils.resource("textures/gui/jei2.png");
    public static final DecimalFormat FORMATTER = new DecimalFormat("0.##s");

    public ResourceLocation getPluginUid() {
        return Utils.resource("plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FreezerSolidifyingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CuttingBoardSlicingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FryingPanCookingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MicrowaveHeatingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ToasterToastingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GrillCookingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CuttingBoardCombiningCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkbenchConstructingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new OvenBakingCategory(helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Plugin.getRecipeManager();
        registration.addRecipes(FreezerSolidifyingCategory.TYPE, this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.FREEZER_SOLIDIFYING.get()));
        registration.addRecipes(CuttingBoardSlicingCategory.TYPE, this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get()));
        registration.addRecipes(FryingPanCookingCategory.TYPE, this.getFryingPanRecipes());
        registration.addRecipes(MicrowaveHeatingCategory.TYPE, this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.MICROWAVE_HEATING.get()));
        registration.addRecipes(ToasterToastingCategory.TYPE, this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.TOASTER_HEATING.get()));
        registration.addRecipes(GrillCookingCategory.TYPE, this.getGrillRecipes());
        registration.addRecipes(CuttingBoardCombiningCategory.TYPE, this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get()));
        registration.addRecipes(WorkbenchConstructingCategory.TYPE, this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get()));
        registration.addRecipes(OvenBakingCategory.TYPE, this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.OVEN_BAKING.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ELECTRICITY_GENERATOR_LIGHT.get()), new RecipeType[]{RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ELECTRICITY_GENERATOR_DARK.get()), new RecipeType[]{RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FRYING_PAN.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GRILL_RED.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiScreenHandler(ComputerScreen.class, (IScreenHandler)new IScreenHandler<ComputerScreen>(){

            @Nullable
            public IGuiProperties apply(ComputerScreen guiScreen) {
                return null;
            }
        });
    }

    private <C extends Container, T extends Recipe<C>> List<T> getRecipes(net.minecraft.world.item.crafting.RecipeType<T> type) {
        return Plugin.getRecipeManager().m_44013_(type).stream().map(RecipeHolder::f_291008_).toList();
    }

    private List<ProcessingRecipe> getFryingPanRecipes() {
        ArrayList<ProcessingRecipe> recipes = new ArrayList<ProcessingRecipe>();
        recipes.addAll(this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.FRYING_PAN_COOKING.get()));
        recipes.addAll(this.getRecipes(net.minecraft.world.item.crafting.RecipeType.f_44111_).stream().map(recipe -> ProcessingRecipe.Item.from((AbstractCookingRecipe)recipe, Plugin.getRegistryAccess())).toList());
        return recipes;
    }

    private List<ProcessingRecipe> getGrillRecipes() {
        ArrayList<ProcessingRecipe> recipes = new ArrayList<ProcessingRecipe>();
        recipes.addAll(this.getRecipes((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.GRILL_COOKING.get()));
        recipes.addAll(this.getRecipes(net.minecraft.world.item.crafting.RecipeType.f_44111_).stream().map(recipe -> ProcessingRecipe.Item.from((AbstractCookingRecipe)recipe, Plugin.getRegistryAccess())).toList());
        return recipes;
    }

    public static RecipeManager getRecipeManager() {
        ClientPacketListener listener = Objects.requireNonNull(Minecraft.m_91087_().m_91403_());
        return listener.m_105141_();
    }

    public static Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    private static RegistryAccess getRegistryAccess() {
        ClientPacketListener listener = Objects.requireNonNull(Minecraft.m_91087_().m_91403_());
        return listener.m_105152_();
    }

    public static ItemStack getResult(Recipe<?> recipe) {
        return recipe.m_8043_(Plugin.getRegistryAccess());
    }

    public static List<ItemStack> getTagItems(TagKey<Item> tag) {
        return StreamSupport.stream(BuiltInRegistries.f_257033_.m_206058_(tag).spliterator(), false).map(holder -> new ItemStack((ItemLike)holder.m_203334_())).toList();
    }

    public static List<Component> getItemTooltip(ItemLike item) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        boolean advanced = minecraft.f_91066_.f_92125_;
        return new ItemStack(item).m_41651_((Player)player, (TooltipFlag)(advanced ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
    }
}

