/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ToiletBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ToiletBlock
extends FurnitureHorizontalEntityBlock {
    public ToiletBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape seatShape = Block.m_49796_((double)0.0, (double)4.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0);
        VoxelShape tankShape = Block.m_49796_((double)11.0, (double)10.0, (double)2.0, (double)16.0, (double)17.0, (double)14.0);
        VoxelShape lidShape = Block.m_49796_((double)10.0, (double)17.0, (double)2.0, (double)16.0, (double)19.0, (double)14.0);
        VoxelShape supportShape = Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)12.0);
        VoxelShape combinedShape = VoxelShapeHelper.combine(List.of(seatShape, tankShape, lidShape, supportShape));
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> VoxelShapeHelper.rotateHorizontally(combinedShape, (Direction)state.m_61143_((Property)DIRECTION)))));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            ToiletBlockEntity toilet;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ToiletBlockEntity && (toilet = (ToiletBlockEntity)blockEntity).interact(player, hand, result) != InteractionResult.PASS) {
                return InteractionResult.CONSUME;
            }
            Vec3 hit = result.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)pos));
            if (hit.m_7098_() <= 0.625 && Seat.sit(player, pos, Utils.pixels(10.0), ((Direction)state.m_61143_((Property)DIRECTION)).m_122424_())) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        ToiletBlockEntity toilet;
        FluidContainer container;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ToiletBlockEntity && (container = (toilet = (ToiletBlockEntity)blockEntity).getFluidContainer()) != null) {
            this.handleEvent(level, pos, container);
        }
    }

    private void handleEvent(ServerLevel level, BlockPos pos, FluidContainer container) {
        SoundEvent event = Services.FLUID.getBucketEmptySound((Fluid)Fluids.f_76193_);
        if (Fluids.f_76193_.m_6212_(container.getStoredFluid()) && event != null) {
            Vec3 center = Vec3.m_82512_((Vec3i)pos);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123769_, center.f_82479_, center.f_82480_, center.f_82481_, 10, 0.0, 0.0, 0.0, 0.0);
            level.m_5594_(null, pos, event, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (Fluids.f_76195_.m_6212_(container.getStoredFluid())) {
            Vec3 center = Vec3.m_82512_((Vec3i)pos);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, center.f_82479_, center.f_82480_, center.f_82481_, 5, 0.0, 0.0, 0.0, 0.0);
            level.m_5594_(null, pos, SoundEvents.f_11909_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ToiletBlockEntity(pos, state);
    }
}

