/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.furniture.refurbished.blockentity.PlateBlockEntity;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlateBlock
extends FallingBlock
implements EntityBlock,
BlockTagSupplier {
    private static final MapCodec<PlateBlock> CODEC = PlateBlock.m_306223_(PlateBlock::new);
    protected final Map<BlockState, VoxelShape> shapes = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());

    public PlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.5, (double)13.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> baseShape)));
    }

    protected MapCodec<PlateBlock> m_304657_() {
        return CODEC;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.shapes.get(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PlateBlockEntity) {
            PlateBlockEntity plate = (PlateBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (!level.m_5776_()) {
                if (player.m_20202_() instanceof Seat && plate.eat(player)) {
                    return InteractionResult.CONSUME;
                }
                if (plate.placeItem(player, heldItem)) {
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.CONSUME;
                }
                if (plate.popItem()) {
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof Container) {
            Container container = (Container)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PlateBlockEntity(pos, state);
    }

    protected void m_6788_(FallingBlockEntity entity) {
        entity.m_272001_();
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = Vec3.m_82539_((Vec3i)pos);
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_49966_()), center.f_82479_, center.f_82480_ + 0.0625, center.f_82481_, 10, 0.25, 0.25, 0.25, 0.0);
            serverLevel.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 0.5f + 0.2f * level.f_46441_.m_188501_());
        }
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_);
    }
}

