/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.LatticeFenceGateBlock;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class LatticeFenceBlock
extends CrossCollisionBlock
implements BlockTagSupplier {
    private static final MapCodec<LatticeFenceBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WoodType.f_303492_.fieldOf("wood_type").forGetter(block -> block.type), (App)LatticeFenceBlock.m_305607_()).apply((Applicative)builder, LatticeFenceBlock::new));
    private final WoodType type;

    public LatticeFenceBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(2.0f, 2.0f, 16.0f, 16.0f, 24.0f, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    protected MapCodec<LatticeFenceBlock> m_304657_() {
        return CODEC;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getFenceState(state, level, pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getFenceState(this.m_49966_(), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    private BlockState getFenceState(BlockState state, LevelAccessor level, BlockPos pos) {
        FluidState fluid = level.m_6425_(pos);
        boolean north = this.canConnectToFace(level, pos, Direction.NORTH);
        boolean east = this.canConnectToFace(level, pos, Direction.EAST);
        boolean south = this.canConnectToFace(level, pos, Direction.SOUTH);
        boolean west = this.canConnectToFace(level, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(north))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(south))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(west))).m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    private boolean canConnectToFace(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockState state = level.m_8055_(pos = pos.m_121945_(direction));
        boolean isGate = state.m_60734_() instanceof LatticeFenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return !LatticeFenceBlock.m_152463_((BlockState)state) && state.m_60783_((BlockGetter)level, pos, direction.m_122424_()) || state.m_60734_() instanceof LatticeFenceBlock || isGate;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Deprecated
    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52309_, f_52310_, f_52312_, f_52311_, f_52313_});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144280_);
    }
}

