/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHeatingSource;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FryingPanBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private static final MapCodec<FryingPanBlock> CODEC = FryingPanBlock.m_306223_(FryingPanBlock::new);

    public FryingPanBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<FryingPanBlock> m_304657_() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)2.5, (double)1.0, (double)2.5, (double)13.5, (double)4.0, (double)13.5);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> baseShape)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Vec3 clickVec = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)pos));
        Direction forward = context.m_8125_();
        Direction right = forward.m_122427_();
        double side = right.m_122434_().m_6150_(clickVec.f_82479_, 0.0, clickVec.f_82481_);
        side = Math.abs((double)Math.min(right.m_122421_().m_122540_(), 0) + side);
        forward = side < 0.5 ? forward.m_122424_() : forward;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)forward)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(this.isHeated(context.m_43725_(), pos)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && result.m_82434_() != Direction.DOWN && (blockEntity = level.m_7702_(pos)) instanceof FryingPanBlockEntity) {
            FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_150930_((Item)ModItems.SPATULA.get())) {
                fryingPan.flipItem();
                FryingPanBlock.playSpatulaScoopSound(level, pos, 0.1875);
            } else if (!stack.m_41619_()) {
                if (fryingPan.placeContents(level, stack, player.m_6350_().m_122416_()) && !player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            } else {
                fryingPan.removeContents();
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.m_7702_(pos.m_7495_()) instanceof IHeatingSource;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FryingPanBlockEntity(pos, state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FryingPanBlockEntity) {
            double posZ;
            double posY;
            FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)blockEntity;
            if (!fryingPan.m_8020_(0).m_41619_() && fryingPan.isFlippingNeeded()) {
                double posX = (double)pos.m_123341_() + 0.35 + 0.3 * level.f_46441_.m_188500_();
                posY = (double)pos.m_123342_() + 0.15;
                posZ = (double)pos.m_123343_() + 0.35 + 0.3 * level.f_46441_.m_188500_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.5, 0.0, 0.05, 0.0);
                fryingPan.spawnSteam(level, posX, posY, posZ);
            }
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && fryingPan.m_8020_(0).m_41619_() && source.m_188503_(2) == 0) {
                double posX = (double)pos.m_123341_() + 0.3 + 0.4 * level.f_46441_.m_188500_();
                posY = (double)pos.m_123342_() + 0.15;
                posZ = (double)pos.m_123343_() + 0.3 + 0.4 * level.f_46441_.m_188500_();
                level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), posX, posY, posZ, 0.0, 0.05, 0.0);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return FryingPanBlock.createTicker(type, (BlockEntityType)ModBlockEntities.FRYING_PAN.get(), FryingPanBlockEntity::clientTick);
        }
        return null;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos $$4, boolean $$5) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (this.isHeated(level, pos)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (!this.isHeated(level, pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private boolean isHeated(Level level, BlockPos pos) {
        IHeatingSource source;
        BlockEntity blockEntity;
        BlockPos belowPos = pos.m_7495_();
        return level != null && (blockEntity = level.m_7702_(belowPos)) instanceof IHeatingSource && (source = (IHeatingSource)blockEntity).isHeating();
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_);
    }

    public static void playSpatulaScoopSound(Level level, BlockPos pos, double offset) {
        Vec3 vec = Vec3.m_82539_((Vec3i)pos);
        level.m_6263_(null, vec.f_82479_, vec.f_82480_ + offset, vec.f_82481_, (SoundEvent)ModSounds.ITEM_SPATULA_SCOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

