/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FreezerBlock;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FridgeBlockEntity;
import com.mrcrayfish.furniture.refurbished.data.DropWithName;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier,
DropWithName {
    private static final MapCodec<FridgeBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)MetalType.CODEC.fieldOf("metal_type").forGetter(block -> block.type), (App)FridgeBlock.m_305607_()).apply((Applicative)builder, FridgeBlock::new));
    protected final MetalType type;

    public FridgeBlock(MetalType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public MetalType getMetalType() {
        return this.type;
    }

    protected MapCodec<FridgeBlock> m_304657_() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape closedShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape openShape = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(VoxelShapeHelper.rotateHorizontally(open ? openShape : closedShape, direction));
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Direction)state.m_61143_((Property)DIRECTION)).m_122424_() == result.m_82434_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FridgeBlockEntity) {
                FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)fridge);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (!state.m_60713_(newState.m_60734_()) && level.m_8055_(pos.m_7495_()).m_60734_() instanceof FreezerBlock) {
            level.m_7471_(pos.m_7495_(), false);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof FridgeBlockEntity) {
            FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
            fridge.m_58638_(stack.m_41786_());
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FridgeBlockEntity(pos, state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity entity = (BasicLootBlockEntity)blockEntity;
            entity.updateOpenerCount();
        }
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_, BlockTags.f_144286_);
    }
}

