/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesstarlight.mixin;

import de.ellpeck.naturesstarlight.NaturesStarlight;
import de.ellpeck.naturesstarlight.aura.StarlightIncreaseEffect;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SkyCollectionHelper.class})
public class MixinSkyCollectionHelper {
    @OnlyIn(value=Dist.CLIENT)
    @Inject(at={@At(value="RETURN")}, method={"getSkyNoiseDistributionClient(Lnet/minecraft/util/RegistryKey;Lnet/minecraft/util/math/BlockPos;)Ljava/util/Optional;"}, remap=false, cancellable=true)
    private static void getSkyNoiseDistributionClient(RegistryKey<World> dim, BlockPos pos, CallbackInfoReturnable<Optional<Float>> callback) {
        float ret = ((Optional)callback.getReturnValue()).orElse(Float.valueOf(0.0f)).floatValue();
        float newFactor = MixinSkyCollectionHelper.modifyDistribution((World)Minecraft.func_71410_x().field_71441_e, pos, ret);
        callback.setReturnValue(Optional.of(Float.valueOf(newFactor)));
    }

    @Inject(at={@At(value="RETURN")}, method={"getSkyNoiseDistribution(Lnet/minecraft/world/ISeedReader;Lnet/minecraft/util/math/BlockPos;)F"}, remap=false, cancellable=true)
    private static void getSkyNoiseDistribution(ISeedReader world, BlockPos pos, CallbackInfoReturnable<Float> callback) {
        callback.setReturnValue((Object)Float.valueOf(MixinSkyCollectionHelper.modifyDistribution((World)world.func_201672_e(), pos, ((Float)callback.getReturnValue()).floatValue())));
    }

    private static float modifyDistribution(World world, BlockPos pos, float distribution) {
        float factor = StarlightIncreaseEffect.getCurrentFactor(world, pos);
        if (factor > 0.0f) {
            distribution += factor * ((Float)NaturesStarlight.starlightEffectAddedStarlight.get()).floatValue();
        }
        return distribution;
    }
}

