/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesstarlight.aura;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesstarlight.NaturesStarlight;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class StarlightIncreaseEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesstarlight", "starlight_increase");

    public IDrainSpotEffect.ActiveType isActiveHere(PlayerEntity player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (StarlightIncreaseEffect.getFactor(player.field_70170_p, player.func_233580_cy_()) <= 0.0f) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_233580_cy_(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    public ItemStack getDisplayIcon() {
        return new ItemStack((IItemProvider)ItemsAS.STARDUST);
    }

    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (StarlightIncreaseEffect.getCurrentFactor(world, pos) > 0.0f) {
            auraChunk.drainAura(pos, ((Integer)NaturesStarlight.starlightEffectAuraDrain.get()).intValue());
        }
    }

    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return true;
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public static float getCurrentFactor(World world, BlockPos pos) {
        if (!NaturesAuraAPI.instance().isEffectPowderActive(world, pos, NAME)) {
            return 0.0f;
        }
        return StarlightIncreaseEffect.getFactor(world, pos);
    }

    private static float getFactor(World world, BlockPos pos) {
        int aura = IAuraChunk.getAuraInArea((IWorld)world, (BlockPos)pos, (int)30);
        return aura >= 1500000 ? Math.min(1.0f, (float)aura / 5000000.0f) : 0.0f;
    }
}

