/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesstarlight.astral.perk;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.perk.type.vanilla.VanillaAttributeType;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class ToolIncreasePerk
extends VanillaAttributeType {
    private static final UUID ID = UUID.fromString("869d6a47-62c2-47ca-8d3d-41226566a1a4");

    public ToolIncreasePerk() {
        super(new ResourceLocation("naturesstarlight", "tool_increase"));
    }

    protected void attachListeners(IEventBus eventBus) {
        eventBus.addListener(EventPriority.LOW, this::onBreakSpeed);
    }

    public UUID getID(ModifierType mode) {
        return ID;
    }

    public String getDescription() {
        return "Perk ToolIncrease";
    }

    @Nonnull
    public Attribute getAttribute() {
        return Attributes.field_233823_f_;
    }

    private void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        if (!ToolIncreasePerk.shouldWorkRightNow(player)) {
            return;
        }
        LogicalSide side = this.getSide((Entity)player);
        if (!this.hasTypeApplied(player, side)) {
            return;
        }
        float speed = PerkAttributeHelper.getOrCreateMap((PlayerEntity)player, (LogicalSide)side).modifyValue(player, ResearchHelper.getProgress((PlayerEntity)player, (LogicalSide)side), (PerkAttributeType)this, event.getNewSpeed());
        speed = AttributeEvent.postProcessModded((PlayerEntity)player, (PerkAttributeType)this, (float)speed);
        event.setNewSpeed(speed);
    }

    private static boolean shouldWorkRightNow(PlayerEntity player) {
        int aura = IAuraChunk.getAuraInArea((IWorld)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (int)30);
        return aura >= 1500000;
    }

    public void onModeApply(PlayerEntity player, ModifierType mode, LogicalSide side) {
        AttributeModifier modifier;
        ModifiableAttributeInstance attr = player.func_233645_dx_().func_233779_a_(this.getAttribute());
        if (attr == null) {
            return;
        }
        if (side.isClient() && (modifier = attr.func_111127_a(this.getID(mode))) != null) {
            if (!(modifier instanceof Modifier)) {
                attr.func_188479_b(this.getID(mode));
            } else {
                return;
            }
        }
        switch (mode) {
            case ADDITION: {
                attr.func_233767_b_((AttributeModifier)new Modifier(this.getID(mode), this.getDescription() + " Add", (PerkAttributeType)this, mode, player, side));
                break;
            }
            case ADDED_MULTIPLY: {
                attr.func_233767_b_((AttributeModifier)new Modifier(this.getID(mode), this.getDescription() + " Multiply Add", (PerkAttributeType)this, mode, player, side));
                break;
            }
            case STACKING_MULTIPLY: {
                attr.func_233767_b_((AttributeModifier)new Modifier(this.getID(mode), this.getDescription() + " Stack Add", (PerkAttributeType)this, mode, player, side));
                break;
            }
        }
    }

    private static class Modifier
    extends AttributeModifier {
        private final PlayerEntity player;
        private final LogicalSide side;
        private final PerkAttributeType type;

        public Modifier(UUID idIn, String nameIn, PerkAttributeType type, ModifierType mode, PlayerEntity player, LogicalSide side) {
            this(idIn, nameIn, type, mode.getVanillaAttributeOperation(), player, side);
        }

        public Modifier(UUID idIn, String nameIn, PerkAttributeType type, AttributeModifier.Operation operationIn, PlayerEntity player, LogicalSide side) {
            super(idIn, nameIn, operationIn == AttributeModifier.Operation.MULTIPLY_TOTAL ? 1.0 : 0.0, operationIn);
            this.player = player;
            this.side = side;
            this.type = type;
        }

        public double func_111164_d() {
            if (!ToolIncreasePerk.shouldWorkRightNow(this.player)) {
                return 0.0;
            }
            ModifierType mode = ModifierType.fromVanillaAttributeOperation((AttributeModifier.Operation)this.func_220375_c());
            return PerkAttributeHelper.getOrCreateMap((PlayerEntity)this.player, (LogicalSide)this.side).getModifier(this.player, ResearchHelper.getProgress((PlayerEntity)this.player, (LogicalSide)this.side), this.type, mode) - 1.0f;
        }
    }
}

