/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesstarlight.astral;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.LogicalSide;

public class NaritisMantleEffect
extends MantleEffect {
    public static final NaritisConfig CONFIG = new NaritisConfig();

    public NaritisMantleEffect(IWeakConstellation constellation) {
        super(constellation);
    }

    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    protected boolean usesTickMethods() {
        return true;
    }

    protected void tickServer(PlayerEntity player) {
        if (player.field_70170_p.func_82737_E() % 20L != 0L) {
            return;
        }
        float charge = ((Float)NaritisMantleEffect.CONFIG.chargeConvertedPerSecond.get()).floatValue();
        if (!AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, charge)) {
            return;
        }
        int aura = MathHelper.func_76141_d((float)(charge * ((Float)NaritisMantleEffect.CONFIG.chargeToAuraRatio.get()).floatValue()));
        if (!NaturesAuraAPI.instance().insertAuraIntoPlayer(player, aura, true)) {
            return;
        }
        NaturesAuraAPI.instance().insertAuraIntoPlayer(player, aura, false);
        AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Float)NaritisMantleEffect.CONFIG.chargeConvertedPerSecond.get()).floatValue(), false);
    }

    public static class NaritisConfig
    extends MantleEffect.Config {
        public ForgeConfigSpec.ConfigValue<Float> chargeToAuraRatio;
        public ForgeConfigSpec.ConfigValue<Float> chargeConvertedPerSecond;

        public NaritisConfig() {
            super("naritis");
        }

        public void createEntries(ForgeConfigSpec.Builder builder) {
            builder.push(this.getPath());
            super.createEntries(builder);
            this.chargeToAuraRatio = builder.comment("The amount of aura that one unit of charge creates").define("chargeToAuraRatio", (Object)Float.valueOf(0.01f));
            this.chargeConvertedPerSecond = builder.comment("The amount of charge that is converted into aura per second").define("chargeConvertedPerSecond", (Object)Float.valueOf(6000.0f));
            builder.pop(3);
        }

        protected String translationKey(String key) {
            return "config." + this.getFullPath() + '.' + key;
        }
    }
}

