/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesstarlight.astral;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.event.PlayerAffectionFlags;
import hellfirepvp.astralsorcery.common.item.crystal.ItemAttunedCrystalBase;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class NaritisConstellationEffect
extends ConstellationEffect {
    public static final NaritisConfig CONFIG = new NaritisConfig();
    private static final PlayerAffectionFlags.AffectionFlag AFFECTION = NaritisConstellationEffect.makeAffectionFlag((String)"naritis");

    public NaritisConstellationEffect(@Nonnull ILocatable origin, @Nonnull IWeakConstellation cst) {
        super(origin, cst);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        IMinorConstellation trait;
        if (world.func_82737_E() % 60L != 0L) {
            return;
        }
        ConstellationEffectProperties prop = this.createProperties(pedestal.getMirrorCount());
        ItemStack socket = pedestal.getCurrentCrystal();
        if (!socket.func_190926_b() && socket.func_77973_b() instanceof ItemAttunedCrystalBase && (trait = ((ItemAttunedCrystalBase)socket.func_77973_b()).getTraitConstellation(socket)) != null) {
            trait.affectConstellationEffect(prop);
        }
        for (int i = world.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
            NaturesAuraAPI.instance().spawnMagicParticle((double)((float)pos.func_177958_n() + 0.5f) + world.field_73012_v.nextGaussian() * 1.5, (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f) + world.field_73012_v.nextGaussian() * 1.5, world.field_73012_v.nextGaussian() * (double)0.01f, (double)(world.field_73012_v.nextFloat() * 0.04f + 0.02f), world.field_73012_v.nextGaussian() * (double)0.01f, prop.isCorrupted() ? 8854540 : 9030711, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 80, 0.0f, false, true);
        }
    }

    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        if (world.field_72995_K) {
            return false;
        }
        int radius = MathHelper.func_76143_f((double)properties.getSize());
        if (properties.isCorrupted()) {
            BlockPos spot = IAuraChunk.getHighestSpot((IWorld)world, (BlockPos)pos, (int)radius, (BlockPos)pos);
            IAuraChunk.getAuraChunk((IWorld)world, (BlockPos)spot).drainAura(spot, ((Integer)NaritisConstellationEffect.CONFIG.auraDrainPerTick.get()).intValue());
            TileRitualPedestal pedestal = this.getPedestal(world, pos);
            if (pedestal != null) {
                Helper.getTileEntitiesInArea((IWorld)world, (BlockPos)pos, (int)radius, tile -> {
                    if (tile instanceof TileEntityImpl) {
                        NaritisConstellationEffect.setLastAffectingPedestal((TileEntityImpl)tile, pedestal);
                    }
                    return false;
                });
            }
        } else {
            BlockPos spot;
            if (IAuraChunk.getAuraInArea((IWorld)world, (BlockPos)pos, (int)radius) >= 2000000) {
                return false;
            }
            for (int toAdd = ((Integer)NaritisConstellationEffect.CONFIG.auraPerTick.get()).intValue(); toAdd > 0; toAdd -= IAuraChunk.getAuraChunk((IWorld)world, (BlockPos)spot).storeAura(spot, toAdd)) {
                spot = IAuraChunk.getLowestSpot((IWorld)world, (BlockPos)pos, (int)radius, (BlockPos)pos);
            }
        }
        return true;
    }

    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    public PlayerAffectionFlags.AffectionFlag getPlayerAffectionFlag() {
        return AFFECTION;
    }

    public static TileRitualPedestal getLastAffectingPedestal(TileEntityImpl tile) {
        long packedPos = tile.getTileData().func_74763_f("naturesstarlight:affecting_pedestal");
        if (packedPos == 0L) {
            return null;
        }
        BlockPos pos = BlockPos.func_218283_e((long)packedPos);
        TileEntity ret = tile.func_145831_w().func_175625_s(pos);
        return ret instanceof TileRitualPedestal ? (TileRitualPedestal)ret : null;
    }

    public static void setLastAffectingPedestal(TileEntityImpl tile, TileRitualPedestal affecting) {
        tile.getTileData().func_74772_a("naturesstarlight:affecting_pedestal", affecting.func_174877_v().func_218275_a());
    }

    public static class NaritisConfig
    extends ConstellationEffect.Config {
        public ForgeConfigSpec.ConfigValue<Integer> auraPerTick;
        public ForgeConfigSpec.ConfigValue<Integer> auraDrainPerTick;
        public ForgeConfigSpec.ConfigValue<Float> auraGenIncreaseFactor;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> engravingEnchantments;

        public NaritisConfig() {
            super("naritis", 5.0, 2.5);
        }

        public void createEntries(ForgeConfigSpec.Builder builder) {
            builder.push(this.getPath());
            super.createEntries(builder);
            this.auraPerTick = builder.comment("Defines the amount of aura that this ritual generates per tick by default").define("auraPerTick", (Object)350);
            this.auraDrainPerTick = builder.comment("Defines the amount of aura the corrupted version of this ritual drains per tick by default").define("auraDrainPerTick", (Object)75);
            this.auraGenIncreaseFactor = builder.comment("Defines the factor that the corrupted version of this ritual increases aura generation in the area by").define("auraGenIncreaseFactor", (Object)Float.valueOf(2.5f));
            this.engravingEnchantments = builder.comment("The enchantments that can be applied using stellar refraction, along with the minimum and maximum applied levels").defineList("engravingEnchantments", Arrays.asList("naturesaura:aura_mending, 1, 1", "minecraft:silk_touch, 1, 1", "minecraft:efficiency, 5, 6", "minecraft:thorns, 4, 6"), s -> true);
            builder.pop(3);
        }

        protected String translationKey(String key) {
            return "config." + this.getFullPath() + '.' + key;
        }
    }
}

