/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesstarlight;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesstarlight.astral.NaritisConstellationEffect;
import de.ellpeck.naturesstarlight.astral.NaritisMantleEffect;
import de.ellpeck.naturesstarlight.astral.perk.AuraProtectionPerk;
import de.ellpeck.naturesstarlight.astral.perk.ToolIncreasePerk;
import de.ellpeck.naturesstarlight.aura.CrystalGeneratorBlock;
import de.ellpeck.naturesstarlight.aura.CrystalGeneratorTileEntity;
import de.ellpeck.naturesstarlight.aura.StarlightIncreaseEffect;
import hellfirepvp.astralsorcery.common.constellation.Constellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProvider;
import hellfirepvp.astralsorcery.common.constellation.engraving.EngravingEffect;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.crystal.CrystalProperty;
import hellfirepvp.astralsorcery.common.crystal.property.PropertyConstellation;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registry {
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"naturesstarlight");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"naturesstarlight");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"naturesstarlight");
    public static final RegistryObject<Block> CRYSTAL_GENERATOR_BLOCK = BLOCKS.register("crystal_generator", CrystalGeneratorBlock::new);
    public static final RegistryObject<Item> CRYSTAL_GENERATOR_ITEM = ITEMS.register("crystal_generator", () -> new BlockItem((Block)CRYSTAL_GENERATOR_BLOCK.get(), new Item.Properties().func_200916_a(NaturesAura.CREATIVE_TAB)));
    public static final RegistryObject<TileEntityType<?>> CRYSTAL_GENERATOR_TILE = TILE_ENTITIES.register("crystal_generator", () -> TileEntityType.Builder.func_223042_a(CrystalGeneratorTileEntity::new, (Block[])new Block[]{(Block)CRYSTAL_GENERATOR_BLOCK.get()}).func_206865_a(null));
    public static final Lazy<IWeakConstellation> NARITIS = Lazy.of(() -> {
        Constellation.Weak ret = new Constellation.Weak("naritis", new Color(2001182));
        StarLocation tip = ret.addStar(5, 3);
        StarLocation tri1 = ret.addStar(24, 13);
        ret.addConnection(tip, tri1);
        StarLocation tri2 = ret.addStar(20, 17);
        ret.addConnection(tri1, tri2);
        StarLocation tri3 = ret.addStar(28, 22);
        ret.addConnection(tri2, tri3);
        ret.addConnection(tri3, tri1);
        StarLocation isolated = ret.addStar(15, 16);
        ret.addConnection(tip, isolated);
        StarLocation line1 = ret.addStar(7, 17);
        ret.addConnection(tip, line1);
        StarLocation line2 = ret.addStar(12, 21);
        ret.addConnection(line1, line2);
        return ret;
    });
    public static PerkAttributeType toolIncreasePerk;
    public static PerkAttributeType auraProtectionPerk;

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TILE_ENTITIES.register(bus);
        BLOCKS.register(bus);
        ITEMS.register(bus);
        NaturesAuraAPI.DRAIN_SPOT_EFFECTS.put(StarlightIncreaseEffect.NAME, StarlightIncreaseEffect::new);
        NaturesAuraAPI.EFFECT_POWDERS.put(StarlightIncreaseEffect.NAME, 543372);
    }

    @SubscribeEvent
    public static void registerConstellations(RegistryEvent.Register<IConstellation> event) {
        event.getRegistry().register((IForgeRegistryEntry)NARITIS.get());
    }

    @SubscribeEvent
    public static void registerConstellationEffects(RegistryEvent.Register<ConstellationEffectProvider> event) {
        event.getRegistry().register((IForgeRegistryEntry)new ConstellationEffectProvider((IWeakConstellation)NARITIS.get()){

            public ConstellationEffect createEffect(@Nullable ILocatable origin) {
                return new NaritisConstellationEffect(origin, (IWeakConstellation)NARITIS.get());
            }
        });
    }

    @SubscribeEvent
    public static void registerEngravingEffects(RegistryEvent.Register<EngravingEffect> event) {
        EngravingEffect effect = new EngravingEffect((IConstellation)NARITIS.get());
        for (String s : (List)NaritisConstellationEffect.CONFIG.engravingEnchantments.get()) {
            String[] value = s.split(",");
            ResourceLocation enchName = new ResourceLocation(value[0].trim());
            int min = Integer.parseInt(value[1].trim());
            int max = Integer.parseInt(value[2].trim());
            effect.addEffect((EngravingEffect.ApplicableEffect)new EngravingEffect.EnchantmentEffect(() -> (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchName), min, max));
        }
        effect.addEffect((EngravingEffect.ApplicableEffect)new EngravingEffect.ModifierEffect(() -> toolIncreasePerk, ModifierType.ADDED_MULTIPLY, 0.1f, 0.25f).addApplicableType(EnchantmentType.DIGGER));
        effect.addEffect((EngravingEffect.ApplicableEffect)new EngravingEffect.ModifierEffect(() -> auraProtectionPerk, ModifierType.ADDED_MULTIPLY, 1.0f, 1.0f).addApplicableType(EnchantmentType.ARMOR));
        event.getRegistry().register((IForgeRegistryEntry)effect);
    }

    @SubscribeEvent
    public static void registerCrystalProperties(RegistryEvent.Register<CrystalProperty> event) {
        event.getRegistry().register((IForgeRegistryEntry)new PropertyConstellation((IWeakConstellation)NARITIS.get()));
    }

    @SubscribeEvent
    public static void registerPerkAttributes(RegistryEvent.Register<PerkAttributeType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new PerkAttributeType[]{toolIncreasePerk = new ToolIncreasePerk(), auraProtectionPerk = new AuraProtectionPerk()});
    }

    @SubscribeEvent
    public static void registerMantleEffects(RegistryEvent.Register<MantleEffect> event) {
        event.getRegistry().register((IForgeRegistryEntry)new NaritisMantleEffect((IWeakConstellation)NARITIS.get()));
    }
}

