/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.antiquewaystones;

import com.horriblenerd.antiquewaystones.Config;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.api.MarkerAPI;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="antiquewaystones")
public class AntiqueWaystones {
    public static final String MODID = "antiquewaystones";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final MarkerAPI markerAPI = AtlasAPI.getMarkerAPI();
    private static final ResourceLocation IMAGE_PATH = new ResourceLocation("antiquewaystones", "textures/gui/markers/waystone.png");
    private static final ResourceLocation IMAGE_ID = new ResourceLocation("antiquewaystones", "waystone");
    private static final String TOWERS_MODID = "towers_of_the_wild";
    private final boolean isTowersOfTheWildLoaded;

    public AntiqueWaystones() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::initClient);
        this.isTowersOfTheWildLoaded = ModList.get().isLoaded(TOWERS_MODID);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void initClient(FMLClientSetupEvent event) {
        LOGGER.info("Init waystone marker");
        MarkerType markerType = new MarkerType(new ResourceLocation[]{IMAGE_PATH});
        MarkerType.register((ResourceLocation)IMAGE_ID, (MarkerType)markerType);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide() == LogicalSide.CLIENT) {
            return;
        }
        BlockEntity blockEntity = event.getWorld().m_7702_(event.getPos());
        BlockEntity blockEntity2 = blockEntity;
        if (blockEntity2 instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystone = (WaystoneBlockEntityBase)blockEntity2;
            LOGGER.info(waystone.getWaystone().getName());
            this.tryPutMarkerFromBlockEntity(event.getPlayer(), waystone);
        }
    }

    @SubscribeEvent
    public void onKnownWaystones(KnownWaystonesEvent event) {
        for (IWaystone waystone : event.getWaystones()) {
            LOGGER.info(waystone.getName());
        }
        Balm.getEvents();
    }

    @SubscribeEvent
    public void onWaystoneActivated(WaystoneActivatedEvent event) {
        LOGGER.info("Activated event");
        Player player = event.getPlayer();
        IWaystone waystone = event.getWaystone();
        this.tryPutMarker(player, waystone);
    }

    private void tryPutMarkerFromBlockEntity(Player player, WaystoneBlockEntityBase waystone) {
        BlockPos pos = waystone.m_58899_();
        ResourceLocation ID = IMAGE_ID;
        if (this.isTowersOfTheWildLoaded && ((Boolean)Config.USE_TOWER_ICON.get()).booleanValue() && player.f_19853_ instanceof ServerLevel && this.isTower((ServerLevel)player.f_19853_, pos)) {
            LOGGER.info("Found a tower at: " + pos);
            ID = ResourceLocation.m_135820_((String)"antiqueatlas:tower");
        }
        LOGGER.info("Adding marker to player atlases: " + waystone.getWaystone().getName() + " with markerType: " + ID);
        List playerAtlases = AtlasAPI.getPlayerAtlases((Player)player);
        Iterator iterator = playerAtlases.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            markerAPI.putMarker(player.f_19853_, true, id, ID, (Component)new TextComponent(waystone.getWaystone().getName()), pos.m_123341_(), pos.m_123343_());
        }
    }

    private void tryPutMarker(Player player, IWaystone waystone) {
        BlockPos pos = waystone.getPos();
        ResourceLocation ID = IMAGE_ID;
        if (this.isTowersOfTheWildLoaded && ((Boolean)Config.USE_TOWER_ICON.get()).booleanValue() && player.f_19853_ instanceof ServerLevel && this.isTower((ServerLevel)player.f_19853_, pos)) {
            LOGGER.info("Found a tower at: " + pos);
            ID = ResourceLocation.m_135820_((String)"antiqueatlas:tower");
        }
        LOGGER.info("Adding marker to player atlases: " + waystone.getName() + " with markerType: " + ID);
        List playerAtlases = AtlasAPI.getPlayerAtlases((Player)player);
        Iterator iterator = playerAtlases.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            markerAPI.putMarker(player.f_19853_, true, id, ID, (Component)new TextComponent(waystone.getName()), pos.m_123341_(), pos.m_123343_());
        }
    }

    private boolean isTower(ServerLevel level, BlockPos pos) {
        LOGGER.info("Checking for tower...");
        for (String s : Arrays.asList("tower", "ice_tower", "jungle_tower", "derelict_tower", "derelict_grass_tower", "ocean_tower", "ocean_warm_tower")) {
            float f1;
            float f;
            StructureStart structurePos;
            StructureFeature structure = (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(ResourceLocation.m_135820_((String)("towers_of_the_wild:" + s)));
            if (structure == null || !(structurePos = level.m_8595_().m_47285_(pos, false, structure)).m_73603_() || !((f = (float)Math.abs(pos.m_123341_() - structurePos.m_7148_().m_123341_())) + (f1 = (float)Math.abs(pos.m_123343_() - structurePos.m_7148_().m_123343_())) <= 30.0f)) continue;
            return true;
        }
        return false;
    }
}

