/*
 * Decompiled with CFR 0.152.
 */
package com.horriblenerd.antiquewaystones;

import com.horriblenerd.antiquewaystones.Config;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.api.MarkerAPI;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="antiquewaystones")
public class AntiqueWaystones {
    public static final String MODID = "antiquewaystones";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final MarkerAPI markerAPI = AtlasAPI.getMarkerAPI();
    private static final ResourceLocation IMAGE_PATH = new ResourceLocation("antiquewaystones", "textures/gui/markers/waystone.png");
    private static final ResourceLocation IMAGE_ID = new ResourceLocation("antiquewaystones", "waystone");
    private static final String TOWERS_MODID = "towers_of_the_wild";
    private final boolean isTowersOfTheWildLoaded;

    public AntiqueWaystones() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::initClient);
        this.isTowersOfTheWildLoaded = ModList.get().isLoaded(TOWERS_MODID);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void initClient(FMLClientSetupEvent event) {
        LOGGER.debug("Init waystone marker");
        MarkerType markerType = new MarkerType(new ResourceLocation[]{IMAGE_PATH});
        MarkerType.register((ResourceLocation)IMAGE_ID, (MarkerType)markerType);
    }

    @SubscribeEvent
    public void onWaystoneActivated(WaystoneActivatedEvent event) {
        PlayerEntity player = event.getPlayer();
        IWaystone waystone = event.getWaystone();
        BlockPos pos = waystone.getPos();
        ResourceLocation ID = IMAGE_ID;
        if (this.isTowersOfTheWildLoaded && ((Boolean)Config.USE_TOWER_ICON.get()).booleanValue() && player.field_70170_p instanceof ServerWorld && this.isTower((ServerWorld)player.field_70170_p, pos)) {
            LOGGER.debug("Found a tower at: " + pos);
            ID = ResourceLocation.func_208304_a((String)"antiqueatlas:tower");
        }
        LOGGER.debug("Adding marker to player atlases: " + waystone.getName() + " with markerType: " + ID);
        List playerAtlases = AtlasAPI.getPlayerAtlases((PlayerEntity)player);
        Iterator iterator = playerAtlases.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            markerAPI.putMarker(player.field_70170_p, true, id, ID, (ITextComponent)new StringTextComponent(waystone.getName()), pos.func_177958_n(), pos.func_177952_p());
        }
    }

    private boolean isTower(ServerWorld world, BlockPos pos) {
        LOGGER.debug("Checking for tower...");
        for (String s : Arrays.asList("tower", "ice_tower", "jungle_tower", "derelict_tower", "derelict_grass_tower", "ocean_tower", "ocean_warm_tower")) {
            float f1;
            float f;
            BlockPos structurePos;
            Structure structure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(ResourceLocation.func_208304_a((String)("towers_of_the_wild:" + s)));
            if (structure == null || (structurePos = world.func_241117_a_(structure, pos, 2, false)) == null || !((f = (float)Math.abs(pos.func_177958_n() - structurePos.func_177958_n())) + (f1 = (float)Math.abs(pos.func_177952_p() - structurePos.func_177952_p())) <= 30.0f)) continue;
            return true;
        }
        return false;
    }
}

