/*
 * Decompiled with CFR 0.152.
 */
package io.github.jodlodi.twilightdecor;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.blueprint.common.block.BlueprintLadderBlock;
import com.teamabnormals.blueprint.common.block.BookshelfBlock;
import com.teamabnormals.blueprint.common.block.HedgeBlock;
import com.teamabnormals.blueprint.common.block.LeafCarpetBlock;
import com.teamabnormals.blueprint.common.block.VerticalSlabBlock;
import com.teamabnormals.blueprint.common.block.wood.WoodPostBlock;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import io.github.jodlodi.twilightdecor.TwilightDecor;
import io.github.jodlodi.twilightdecor.types.MagicCarpet;
import io.github.jodlodi.twilightdecor.types.MagicHedge;
import io.github.jodlodi.twilightdecor.types.WoodTypes;
import lilypuree.decorative_blocks.Constants;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.block.TFBlocks;

@Mod.EventBusSubscriber(modid="twilightdecor", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DecorReg {
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Block> BLOCKS;
    public static final BlockSubRegistryHelper HELPER;
    public static final ItemSubRegistryHelper ITEMER;
    public static final Item.Properties modItemProperties;
    public static final RegistryObject<Item> EXPERIMENT_115_PIE;
    public static BlockBehaviour.Properties LEAF_CARPET_PROP;
    public static final RegistryObject<Block> VERTICAL_TWILIGHT_OAK_PLANKS;
    public static final RegistryObject<Block> TWILIGHT_OAK_VERTICAL_SLAB;
    public static final RegistryObject<Block> TWILIGHT_OAK_LADDER;
    public static final RegistryObject<Block> TWILIGHT_OAK_BOOKSHELF;
    public static final RegistryObject<Block> TWILIGHT_OAK_LEAF_CARPET;
    public static final RegistryObject<Block> STRIPPED_TWILIGHT_OAK_POST;
    public static final RegistryObject<Block> TWILIGHT_OAK_POST;
    public static final RegistryObject<Block> TWILIGHT_OAK_HEDGE;
    public static final RegistryObject<Item> TWILIGHT_OAK_BOAT;
    public static final RegistryObject<Block> RAINBOAK_LEAF_CARPET;
    public static final RegistryObject<Block> RAINBOAK_HEDGE;
    public static final RegistryObject<Block> VERTICAL_CANOPY_PLANKS;
    public static final RegistryObject<Block> CANOPY_VERTICAL_SLAB;
    public static final RegistryObject<Block> CANOPY_LADDER;
    public static final RegistryObject<Block> CANOPY_LEAF_CARPET;
    public static final RegistryObject<Block> STRIPPED_CANOPY_POST;
    public static final RegistryObject<Block> CANOPY_POST;
    public static final RegistryObject<Block> CANOPY_HEDGE;
    public static final RegistryObject<Item> CANOPY_BOAT;
    public static final RegistryObject<Block> VERTICAL_MANGROVE_PLANKS;
    public static final RegistryObject<Block> MANGROVE_VERTICAL_SLAB;
    public static final RegistryObject<Block> MANGROVE_LADDER;
    public static final RegistryObject<Block> MANGROVE_BOOKSHELF;
    public static final RegistryObject<Block> MANGROVE_LEAF_CARPET;
    public static final RegistryObject<Block> STRIPPED_MANGROVE_POST;
    public static final RegistryObject<Block> MANGROVE_POST;
    public static final RegistryObject<Block> MANGROVE_HEDGE;
    public static final RegistryObject<Item> MANGROVE_BOAT;
    public static final RegistryObject<Block> VERTICAL_DARKWOOD_PLANKS;
    public static final RegistryObject<Block> DARKWOOD_VERTICAL_SLAB;
    public static final RegistryObject<Block> DARKWOOD_LADDER;
    public static final RegistryObject<Block> DARKWOOD_BOOKSHELF;
    public static final RegistryObject<Block> DARKWOOD_LEAF_CARPET;
    public static final RegistryObject<Block> STRIPPED_DARKWOOD_POST;
    public static final RegistryObject<Block> DARKWOOD_POST;
    public static final RegistryObject<Block> DARKWOOD_HEDGE;
    public static final RegistryObject<Item> DARKWOOD_BOAT;
    public static final RegistryObject<Block> VERTICAL_TIMEWOOD_PLANKS;
    public static final RegistryObject<Block> TIMEWOOD_VERTICAL_SLAB;
    public static final RegistryObject<Block> TIMEWOOD_LADDER;
    public static final RegistryObject<Block> TIMEWOOD_BOOKSHELF;
    public static final RegistryObject<Block> TIMEWOOD_LEAF_CARPET;
    public static final RegistryObject<Block> STRIPPED_TIMEWOOD_POST;
    public static final RegistryObject<Block> TIMEWOOD_POST;
    public static final RegistryObject<Block> TIMEWOOD_HEDGE;
    public static final RegistryObject<Item> TIMEWOOD_BOAT;
    public static final RegistryObject<Block> VERTICAL_TRANSFORMATION_PLANKS;
    public static final RegistryObject<Block> TRANSFORMATION_VERTICAL_SLAB;
    public static final RegistryObject<Block> TRANSFORMATION_LADDER;
    public static final RegistryObject<Block> TRANSFORMATION_BOOKSHELF;
    public static final RegistryObject<Block> TRANSFORMATION_LEAF_CARPET;
    public static final RegistryObject<Block> STRIPPED_TRANSFORMATION_POST;
    public static final RegistryObject<Block> TRANSFORMATION_POST;
    public static final RegistryObject<Block> TRANSFORMATION_HEDGE;
    public static final RegistryObject<Item> TRANSFORMATION_BOAT;
    public static final RegistryObject<Block> VERTICAL_MINING_PLANKS;
    public static final RegistryObject<Block> MINING_VERTICAL_SLAB;
    public static final RegistryObject<Block> MINING_LADDER;
    public static final RegistryObject<Block> MINING_BOOKSHELF;
    public static final RegistryObject<Block> MINING_LEAF_CARPET;
    public static final RegistryObject<Block> STRIPPED_MINING_POST;
    public static final RegistryObject<Block> MINING_POST;
    public static final RegistryObject<Block> MINING_HEDGE;
    public static final RegistryObject<Item> MINING_BOAT;
    public static final RegistryObject<Block> VERTICAL_SORTING_PLANKS;
    public static final RegistryObject<Block> SORTING_VERTICAL_SLAB;
    public static final RegistryObject<Block> SORTING_LADDER;
    public static final RegistryObject<Block> SORTING_BOOKSHELF;
    public static final RegistryObject<Block> SORTING_LEAF_CARPET;
    public static final RegistryObject<Block> STRIPPED_SORTING_POST;
    public static final RegistryObject<Block> SORTING_POST;
    public static final RegistryObject<Block> SORTING_HEDGE;
    public static final RegistryObject<Item> SORTING_BOAT;
    public static ImmutableMap<String, RegistryObject<Block>> decorWoodBlocks;
    public static ImmutableMap<String, RegistryObject<Item>> decorWoodItems;

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
    }

    private static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        BlockBehaviour.Properties woodProperty = BlockBehaviour.Properties.m_60944_((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).m_60978_(1.2f).m_60918_(wood.getSoundType());
        BlockBehaviour.Properties palisadeProperty = BlockBehaviour.Properties.m_60944_((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).m_60913_(2.0f, 4.0f).m_60918_(wood.getSoundType());
        return switch (woodDecorativeBlockType) {
            default -> throw new IncompatibleClassChangeError();
            case WoodDecorativeBlockTypes.BEAM -> new BeamBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.SUPPORT -> new SupportBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.PALISADE -> new PalisadeBlock(palisadeProperty, wood);
            case WoodDecorativeBlockTypes.SEAT -> new SeatBlock(woodProperty, wood);
        };
    }

    static {
        String name;
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"twilightdecor");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"twilightdecor");
        HELPER = (BlockSubRegistryHelper)TwilightDecor.REGISTRY_HELPER.getBlockSubHelper();
        ITEMER = (ItemSubRegistryHelper)TwilightDecor.REGISTRY_HELPER.getItemSubHelper();
        modItemProperties = new Item.Properties().m_41491_(Constants.ITEM_GROUP);
        EXPERIMENT_115_PIE = ITEMER.createCompatItem("farmersdelight", "experiment_115_pie", new Item.Properties().m_41487_(1), CreativeModeTab.f_40755_);
        LEAF_CARPET_PROP = BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76363_).m_60978_(0.0f).m_60918_(SoundType.f_56740_).m_60955_();
        VERTICAL_TWILIGHT_OAK_PLANKS = HELPER.createCompatBlock("quark", "vertical_twilight_oak_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40749_);
        TWILIGHT_OAK_VERTICAL_SLAB = HELPER.createCompatFuelBlock("quark", "twilight_oak_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 150, CreativeModeTab.f_40749_);
        TWILIGHT_OAK_LADDER = HELPER.createCompatFuelBlock("quark", "twilight_oak_ladder", () -> new BlueprintLadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)), 300, CreativeModeTab.f_40750_);
        TWILIGHT_OAK_BOOKSHELF = HELPER.createCompatFuelBlock("quark", "twilight_oak_bookshelf", () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)), 300, CreativeModeTab.f_40749_);
        TWILIGHT_OAK_LEAF_CARPET = HELPER.createCompatBlock("quark", "twilight_oak_leaf_carpet", () -> new LeafCarpetBlock(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        STRIPPED_TWILIGHT_OAK_POST = HELPER.createCompatFuelBlock("quark", "stripped_twilight_oak_post", () -> new WoodPostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        TWILIGHT_OAK_POST = HELPER.createCompatFuelBlock("quark", "twilight_oak_post", () -> new WoodPostBlock(STRIPPED_TWILIGHT_OAK_POST, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        TWILIGHT_OAK_HEDGE = HELPER.createCompatFuelBlock("quark", "twilight_oak_hedge", () -> new HedgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40750_);
        TWILIGHT_OAK_BOAT = ITEMER.createBoatItem("twilight_oak", TFBlocks.TWILIGHT_OAK_PLANKS);
        RAINBOAK_LEAF_CARPET = HELPER.createCompatBlock("quark", "rainboak_leaf_carpet", () -> new LeafCarpetBlock(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        RAINBOAK_HEDGE = HELPER.createCompatFuelBlock("quark", "rainboak_hedge", () -> new HedgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40750_);
        VERTICAL_CANOPY_PLANKS = HELPER.createCompatBlock("quark", "vertical_canopy_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40749_);
        CANOPY_VERTICAL_SLAB = HELPER.createCompatFuelBlock("quark", "canopy_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 150, CreativeModeTab.f_40749_);
        CANOPY_LADDER = HELPER.createCompatFuelBlock("quark", "canopy_ladder", () -> new BlueprintLadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)), 300, CreativeModeTab.f_40750_);
        CANOPY_LEAF_CARPET = HELPER.createCompatBlock("quark", "canopy_leaf_carpet", () -> new LeafCarpetBlock(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        STRIPPED_CANOPY_POST = HELPER.createCompatFuelBlock("quark", "stripped_canopy_post", () -> new WoodPostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        CANOPY_POST = HELPER.createCompatFuelBlock("quark", "canopy_post", () -> new WoodPostBlock(STRIPPED_CANOPY_POST, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        CANOPY_HEDGE = HELPER.createCompatFuelBlock("quark", "canopy_hedge", () -> new HedgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), 300, CreativeModeTab.f_40750_);
        CANOPY_BOAT = ITEMER.createBoatItem("canopy", TFBlocks.CANOPY_PLANKS);
        VERTICAL_MANGROVE_PLANKS = HELPER.createCompatBlock("quark", "vertical_mangrove_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40749_);
        MANGROVE_VERTICAL_SLAB = HELPER.createCompatFuelBlock("quark", "mangrove_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 150, CreativeModeTab.f_40749_);
        MANGROVE_LADDER = HELPER.createCompatFuelBlock("quark", "mangrove_ladder", () -> new BlueprintLadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)), 300, CreativeModeTab.f_40750_);
        MANGROVE_BOOKSHELF = HELPER.createCompatFuelBlock("quark", "mangrove_bookshelf", () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)), 300, CreativeModeTab.f_40749_);
        MANGROVE_LEAF_CARPET = HELPER.createCompatBlock("quark", "mangrove_leaf_carpet", () -> new LeafCarpetBlock(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        STRIPPED_MANGROVE_POST = HELPER.createCompatFuelBlock("quark", "stripped_mangrove_post", () -> new WoodPostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        MANGROVE_POST = HELPER.createCompatFuelBlock("quark", "mangrove_post", () -> new WoodPostBlock(STRIPPED_MANGROVE_POST, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        MANGROVE_HEDGE = HELPER.createCompatFuelBlock("quark", "mangrove_hedge", () -> new HedgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40750_);
        MANGROVE_BOAT = ITEMER.createBoatItem("mangrove", TFBlocks.MANGROVE_PLANKS);
        VERTICAL_DARKWOOD_PLANKS = HELPER.createCompatBlock("quark", "vertical_darkwood_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40749_);
        DARKWOOD_VERTICAL_SLAB = HELPER.createCompatFuelBlock("quark", "darkwood_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 150, CreativeModeTab.f_40749_);
        DARKWOOD_LADDER = HELPER.createCompatFuelBlock("quark", "darkwood_ladder", () -> new BlueprintLadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)), 300, CreativeModeTab.f_40750_);
        DARKWOOD_BOOKSHELF = HELPER.createCompatFuelBlock("quark", "darkwood_bookshelf", () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)), 300, CreativeModeTab.f_40749_);
        DARKWOOD_LEAF_CARPET = HELPER.createCompatBlock("quark", "darkwood_leaf_carpet", () -> new LeafCarpetBlock(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        STRIPPED_DARKWOOD_POST = HELPER.createCompatFuelBlock("quark", "stripped_darkwood_post", () -> new WoodPostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        DARKWOOD_POST = HELPER.createCompatFuelBlock("quark", "darkwood_post", () -> new WoodPostBlock(STRIPPED_DARKWOOD_POST, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        DARKWOOD_HEDGE = HELPER.createCompatFuelBlock("quark", "darkwood_hedge", () -> new HedgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40750_);
        DARKWOOD_BOAT = ITEMER.createBoatItem("darkwood", TFBlocks.DARK_PLANKS);
        VERTICAL_TIMEWOOD_PLANKS = HELPER.createCompatBlock("quark", "vertical_timewood_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40749_);
        TIMEWOOD_VERTICAL_SLAB = HELPER.createCompatFuelBlock("quark", "timewood_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 150, CreativeModeTab.f_40749_);
        TIMEWOOD_LADDER = HELPER.createCompatFuelBlock("quark", "timewood_ladder", () -> new BlueprintLadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)), 300, CreativeModeTab.f_40750_);
        TIMEWOOD_BOOKSHELF = HELPER.createCompatFuelBlock("quark", "timewood_bookshelf", () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)), 300, CreativeModeTab.f_40749_);
        TIMEWOOD_LEAF_CARPET = HELPER.createCompatBlock("quark", "timewood_leaf_carpet", () -> new LeafCarpetBlock(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        STRIPPED_TIMEWOOD_POST = HELPER.createCompatFuelBlock("quark", "stripped_timewood_post", () -> new WoodPostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        TIMEWOOD_POST = HELPER.createCompatFuelBlock("quark", "timewood_post", () -> new WoodPostBlock(STRIPPED_TIMEWOOD_POST, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        TIMEWOOD_HEDGE = HELPER.createCompatFuelBlock("quark", "timewood_hedge", () -> new HedgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40750_);
        TIMEWOOD_BOAT = ITEMER.createBoatItem("timewood", TFBlocks.TIME_PLANKS);
        VERTICAL_TRANSFORMATION_PLANKS = HELPER.createCompatBlock("quark", "vertical_transformation_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40749_);
        TRANSFORMATION_VERTICAL_SLAB = HELPER.createCompatFuelBlock("quark", "transformation_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 150, CreativeModeTab.f_40749_);
        TRANSFORMATION_LADDER = HELPER.createCompatFuelBlock("quark", "transformation_ladder", () -> new BlueprintLadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)), 300, CreativeModeTab.f_40750_);
        TRANSFORMATION_BOOKSHELF = HELPER.createCompatFuelBlock("quark", "transformation_bookshelf", () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)), 300, CreativeModeTab.f_40749_);
        TRANSFORMATION_LEAF_CARPET = HELPER.createCompatBlock("quark", "transformation_leaf_carpet", () -> new MagicCarpet(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        STRIPPED_TRANSFORMATION_POST = HELPER.createCompatFuelBlock("quark", "stripped_transformation_post", () -> new WoodPostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        TRANSFORMATION_POST = HELPER.createCompatFuelBlock("quark", "transformation_post", () -> new WoodPostBlock(STRIPPED_TRANSFORMATION_POST, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        TRANSFORMATION_HEDGE = HELPER.createCompatFuelBlock("quark", "transformation_hedge", () -> new MagicHedge(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40750_);
        TRANSFORMATION_BOAT = ITEMER.createBoatItem("transformation", TFBlocks.TRANSFORMATION_PLANKS);
        VERTICAL_MINING_PLANKS = HELPER.createCompatBlock("quark", "vertical_mining_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40749_);
        MINING_VERTICAL_SLAB = HELPER.createCompatFuelBlock("quark", "mining_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 150, CreativeModeTab.f_40749_);
        MINING_LADDER = HELPER.createCompatFuelBlock("quark", "mining_ladder", () -> new BlueprintLadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)), 300, CreativeModeTab.f_40750_);
        MINING_BOOKSHELF = HELPER.createCompatFuelBlock("quark", "mining_bookshelf", () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)), 300, CreativeModeTab.f_40749_);
        MINING_LEAF_CARPET = HELPER.createCompatBlock("quark", "mining_leaf_carpet", () -> new LeafCarpetBlock(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        STRIPPED_MINING_POST = HELPER.createCompatFuelBlock("quark", "stripped_mining_post", () -> new WoodPostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        MINING_POST = HELPER.createCompatFuelBlock("quark", "mining_post", () -> new WoodPostBlock(STRIPPED_MINING_POST, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        MINING_HEDGE = HELPER.createCompatFuelBlock("quark", "mining_hedge", () -> new HedgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40750_);
        MINING_BOAT = ITEMER.createBoatItem("mining", TFBlocks.MINING_PLANKS);
        VERTICAL_SORTING_PLANKS = HELPER.createCompatBlock("quark", "vertical_sorting_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40749_);
        SORTING_VERTICAL_SLAB = HELPER.createCompatFuelBlock("quark", "sorting_vertical_slab", () -> new VerticalSlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 150, CreativeModeTab.f_40749_);
        SORTING_LADDER = HELPER.createCompatFuelBlock("quark", "sorting_ladder", () -> new BlueprintLadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_)), 300, CreativeModeTab.f_40750_);
        SORTING_BOOKSHELF = HELPER.createCompatFuelBlock("quark", "sorting_bookshelf", () -> new BookshelfBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_)), 300, CreativeModeTab.f_40749_);
        SORTING_LEAF_CARPET = HELPER.createCompatBlock("quark", "sorting_leaf_carpet", () -> new LeafCarpetBlock(LEAF_CARPET_PROP), CreativeModeTab.f_40750_);
        STRIPPED_SORTING_POST = HELPER.createCompatFuelBlock("quark", "stripped_sorting_post", () -> new WoodPostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        SORTING_POST = HELPER.createCompatFuelBlock("quark", "sorting_post", () -> new WoodPostBlock(STRIPPED_SORTING_POST, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40749_);
        SORTING_HEDGE = HELPER.createCompatFuelBlock("quark", "sorting_hedge", () -> new HedgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), 300, CreativeModeTab.f_40750_);
        SORTING_BOAT = ITEMER.createBoatItem("sorting", TFBlocks.SORTING_PLANKS);
        ImmutableMap.Builder decorativeBlockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : WoodTypes.allWoodTypes()) {
                name = wood + "_" + type;
                decorativeBlockBuilder.put((Object)name, (Object)BLOCKS.register(name, () -> DecorReg.createDecorativeBlock(wood, type)));
            }
        }
        decorWoodBlocks = decorativeBlockBuilder.build();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : WoodTypes.allWoodTypes()) {
                name = wood + "_" + type;
                itemBuilder.put((Object)name, (Object)ITEMS.register(name, () -> new BlockItem((Block)((RegistryObject)decorWoodBlocks.get((Object)name)).get(), modItemProperties)));
            }
        }
        decorWoodItems = itemBuilder.build();
    }
}

