/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.azalea;

import com.google.common.collect.ImmutableMap;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.Features;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.placement.FeatureDecorator;
import net.minecraft.world.level.levelgen.placement.FrequencyWithExtraChanceDecoratorConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import samebutdifferent.azalea.block.FloweringAzaleaLogBlock;
import samebutdifferent.azalea.block.grower.ModAzaleaTreeGrower;
import samebutdifferent.azalea.registry.ModBlocks;
import samebutdifferent.azalea.registry.ModConfig;
import samebutdifferent.azalea.registry.ModItems;
import samebutdifferent.azalea.worldgen.ModFeatures;

@Mod(value="azalea")
public class Azalea {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "azalea";

    public Azalea() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_CONFIG);
        ModBlocks.BLOCKS.register(bus);
        ModItems.ITEMS.register(bus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)((Block)ModBlocks.AZALEA_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_AZALEA_LOG.get())).put((Object)((Block)ModBlocks.FLOWERING_AZALEA_LOG.get()), (Object)((Block)ModBlocks.STRIPPED_AZALEA_LOG.get())).put((Object)((Block)ModBlocks.FLOWERING_AZALEA_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_AZALEA_WOOD.get())).put((Object)((Block)ModBlocks.AZALEA_WOOD.get()), (Object)((Block)ModBlocks.STRIPPED_AZALEA_WOOD.get())).build();
        event.enqueueWork(ModFeatures::registerAzaleaTree);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.AZALEA_FLOWER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.AZALEA_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FLOWERING_AZALEA_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.AZALEA_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FLOWERING_AZALEA_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.POTTED_AZALEA_FLOWER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MOSS.get()), (RenderType)RenderType.m_110457_());
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (((Boolean)ModConfig.GENERATE_TREE_NATURALLY.get()).booleanValue() && (event.getCategory() == Biome.BiomeCategory.FOREST || event.getCategory() == Biome.BiomeCategory.PLAINS)) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).add(() -> Feature.f_65760_.m_65815_((FeatureConfiguration)((TreeConfiguration)ModFeatures.MOD_AZALEA_TREE.m_65397_())).m_7679_(Features.Decorators.f_176980_).m_7679_(FeatureDecorator.f_70686_.m_70720_((DecoratorConfiguration)new FrequencyWithExtraChanceDecoratorConfiguration(0, 0.02f * ((Double)ModConfig.TREE_SPAWN_CHANCE_MULTIPLIER.get()).floatValue(), 1))));
        }
    }

    @SubscribeEvent
    public void onBoneMeal(BonemealEvent event) {
        if (((Boolean)ModConfig.OVERRIDE_VANILLA_TREE.get()).booleanValue() && !event.getWorld().f_46443_ && (event.getBlock().m_60734_() == Blocks.f_152541_ || event.getBlock().m_60734_() == Blocks.f_152542_)) {
            event.setResult(Event.Result.ALLOW);
            ServerLevel world = (ServerLevel)event.getWorld();
            ModAzaleaTreeGrower tree = new ModAzaleaTreeGrower();
            tree.m_6334_(world, world.m_7726_().m_8481_(), event.getPos(), event.getBlock(), world.f_46441_);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().f_46443_) {
            Direction direction;
            Level world = event.getWorld();
            Player player = event.getPlayer();
            BlockPos pos = event.getPos();
            BlockState state = world.m_8055_(pos);
            ItemStack stack = event.getItemStack();
            InteractionHand hand = event.getHand();
            Direction direction2 = direction = event.getHitVec().m_82434_().m_122434_() == Direction.Axis.Y ? event.getHitVec().m_82434_().m_122424_() : event.getHitVec().m_82434_();
            if (stack.m_150930_(Items.f_42574_)) {
                if (state.m_60713_(Blocks.f_152542_)) {
                    FloweringAzaleaLogBlock.shearAzalea(world, player, pos, stack, hand, direction, Blocks.f_152541_.m_49966_());
                    player.m_21011_(hand, true);
                }
                if (state.m_60713_(Blocks.f_152471_)) {
                    FloweringAzaleaLogBlock.shearAzalea(world, player, pos, stack, hand, direction, Blocks.f_152470_.m_49966_());
                    player.m_21011_(hand, true);
                }
            }
        }
    }
}

