/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.event.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;

@Environment(value=EnvType.CLIENT)
public class MouseInputEvents {
    public static final Event<BeforeButton> BEFORE_BUTTON = EventFactory.createArrayBacked(BeforeButton.class, callbacks -> (button, modifiers, action) -> {
        for (BeforeButton callback : callbacks) {
            if (!callback.beforeButtonPress(button, modifiers, action)) continue;
            return true;
        }
        return false;
    });
    public static final Event<AfterButton> AFTER_BUTTON = EventFactory.createArrayBacked(AfterButton.class, callbacks -> (button, modifiers, action) -> {
        for (AfterButton callback : callbacks) {
            callback.afterButtonPress(button, modifiers, action);
        }
    });
    public static final Event<BeforeScroll> BEFORE_SCROLL = EventFactory.createArrayBacked(BeforeScroll.class, callbacks -> (deltaX, deltaY) -> {
        for (BeforeScroll callback : callbacks) {
            if (!callback.beforeScroll(deltaX, deltaY)) continue;
            return true;
        }
        return false;
    });
    public static final Event<AfterScroll> AFTER_SCROLL = EventFactory.createArrayBacked(AfterScroll.class, callbacks -> (deltaX, deltaY) -> {
        for (AfterScroll callback : callbacks) {
            callback.afterScroll(deltaX, deltaY);
        }
    });

    public static interface AfterScroll {
        public void afterScroll(double var1, double var3);
    }

    public static interface BeforeScroll {
        public boolean beforeScroll(double var1, double var3);
    }

    public static interface AfterButton {
        public void afterButtonPress(int var1, int var2, Action var3);
    }

    public static enum Action {
        RELEASE,
        PRESS,
        REPEAT;


        public static Action get(int index) {
            return switch (index) {
                case 0 -> RELEASE;
                case 1 -> PRESS;
                case 2 -> REPEAT;
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }
    }

    public static interface BeforeButton {
        public boolean beforeButtonPress(int var1, int var2, Action var3);
    }
}

