/*
 * Decompiled with CFR 0.152.
 */
package com.jadedpacks.jctweaks.helpers;

import com.jadedpacks.jctweaks.Main;
import com.jadedpacks.jctweaks.helpers.Parts;
import com.jadedpacks.jctweaks.helpers.RecipeRemover;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.ItemStackHolderInjector;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ThermalExpansionHelper {
    public static void preInit() {
    }

    public static void init() {
        ItemStackHolderInjector.INSTANCE.inject();
        Main.log.info("Jaded is now fiddling with ThermalExpansion, do not blame TeamCoFH for unexpected explosions");
        ThermalExpansionHelper.removeRecipes();
        ThermalExpansionHelper.addRecipes();
    }

    public static void postInit() {
        ItemStackHolderInjector.INSTANCE.inject();
        ThermalExpansionHelper.addSolarFlux();
    }

    private static void addSolarFlux() {
        if (Parts.mirror != null && Parts.mirror2 != null) {
            RecipeRemover.removeAnyRecipe(Parts.mirror);
            RecipeRemover.removeAnyRecipe(Parts.mirror2);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Parts.mirror, new Object[]{"III", "XSX", Character.valueOf('I'), "blockGlass", Character.valueOf('S'), "ingotSilver"}));
            Main.log.info("Jaded is rearranging solar panels for maximum sunlight or pain, one or the other, possibly both");
        } else {
            Main.log.info("Mirror is missing");
        }
    }

    private static void removeRecipes() {
        if (Loader.isModLoaded((String)"Forestry")) {
            if (Parts.copperBlock == null || Parts.tinBlock != null) {
                // empty if block
            }
            RecipeRemover.removeAnyRecipe(Parts.copperBlock);
            RecipeRemover.removeAnyRecipe(Parts.tinBlock);
            Main.log.info("Jaded is removing Forestry storage blocks because people wanted the other textures");
        }
    }

    private static void addRecipes() {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", 2000);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        Parts.platinumOre.func_77955_b(toSend.func_74775_l("input"));
        Parts.mithrilOre.func_77955_b(toSend.func_74775_l("output"));
        Parts.temana.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerFillRecipe", (NBTTagCompound)toSend);
        toSend = new NBTTagCompound();
        if (Parts.platDust != null) {
            toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            toSend.func_74768_a("secondaryChance", 10);
            toSend.func_74768_a("energy", 2000);
            Parts.silverOre.func_77955_b(toSend.func_74775_l("primaryInput"));
            Parts.platDust.func_77955_b(toSend.func_74775_l("secondaryInput"));
            Parts.platinumIngot.func_77955_b(toSend.func_74775_l("primaryOutput"));
            Parts.mithrilOre.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterRecipe", (NBTTagCompound)toSend);
            toSend = new NBTTagCompound();
        }
        Main.log.info("Jaded is adding mystical metals");
        Main.log.info("JadedTweaks Thermal Expansion tweaks loaded");
    }

    public static void loadComplete() {
        if (Loader.isModLoaded((String)"TConstruct")) {
            if (Parts.gearCopper != null) {
                RecipeRemover.removeAnyRecipe(Parts.gearCopper);
            }
            RecipeRemover.removeAnyRecipe(Parts.gearIron);
            if (Parts.gearTin != null) {
                RecipeRemover.removeAnyRecipe(Parts.gearTin);
            }
            RecipeRemover.removeAnyRecipe(Parts.gearGold);
            RecipeRemover.removeAnyRecipe(Parts.gearSilver);
            if (Parts.gearCopper != null) {
                RecipeRemover.removeAnyRecipe(Parts.gearBronze);
            }
            RecipeRemover.removeAnyRecipe(Parts.gearNickel);
            RecipeRemover.removeAnyRecipe(Parts.gearPlatinum);
            RecipeRemover.removeAnyRecipe(Parts.gearMithril);
            RecipeRemover.removeAnyRecipe(Parts.gearElectrum);
            RecipeRemover.removeAnyRecipe(Parts.gearInvar);
            RecipeRemover.removeAnyRecipe(Parts.gearSignalum);
            RecipeRemover.removeAnyRecipe(Parts.gearLumium);
            RecipeRemover.removeAnyRecipe(Parts.gearEnderium);
            Main.log.info("Jaded says use the smeltery for gear making");
        }
    }
}

