/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.event.common;

import io.github.fabricators_of_create.porting_lib.entity.events.player.PlayerEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_8779;

public abstract class AdvancementEvent
extends PlayerEvent {
    public static final Event<EarnCallback> EARN = EventFactory.createArrayBacked(EarnCallback.class, callbacks -> event -> {
        for (EarnCallback c : callbacks) {
            c.onAdvancementEarn(event);
        }
    });
    public static final Event<ProgressCallback> PROGRESS = EventFactory.createArrayBacked(ProgressCallback.class, callbacks -> event -> {
        for (ProgressCallback c : callbacks) {
            c.onAdvancementProgress(event);
        }
    });
    private final class_8779 advancement;

    public AdvancementEvent(class_1657 player, class_8779 advancement) {
        super(player);
        this.advancement = advancement;
    }

    public class_8779 getAdvancement() {
        return this.advancement;
    }

    @FunctionalInterface
    public static interface ProgressCallback {
        public void onAdvancementProgress(AdvancementProgressEvent var1);
    }

    public static class AdvancementProgressEvent
    extends AdvancementEvent {
        private final class_167 advancementProgress;
        private final String criterionName;
        private final ProgressType progressType;

        public AdvancementProgressEvent(class_1657 player, class_8779 progressed, class_167 advancementProgress, String criterionName, ProgressType progressType) {
            super(player, progressed);
            this.advancementProgress = advancementProgress;
            this.criterionName = criterionName;
            this.progressType = progressType;
        }

        public class_167 getAdvancementProgress() {
            return this.advancementProgress;
        }

        public String getCriterionName() {
            return this.criterionName;
        }

        public ProgressType getProgressType() {
            return this.progressType;
        }

        public void sendEvent() {
            ((ProgressCallback)PROGRESS.invoker()).onAdvancementProgress(this);
        }

        public static enum ProgressType {
            GRANT,
            REVOKE;

        }
    }

    @FunctionalInterface
    public static interface EarnCallback {
        public void onAdvancementEarn(AdvancementEarnEvent var1);
    }

    public static class AdvancementEarnEvent
    extends AdvancementEvent {
        public AdvancementEarnEvent(class_1657 player, class_8779 earned) {
            super(player, earned);
        }

        public void sendEvent() {
            ((EarnCallback)EARN.invoker()).onAdvancementEarn(this);
        }
    }
}

