/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import io.github.fabricators_of_create.porting_lib.util.DeferredBlock;
import io.github.fabricators_of_create.porting_lib.util.DeferredHolder;
import io.github.fabricators_of_create.porting_lib.util.DeferredItem;
import io.github.fabricators_of_create.porting_lib.util.RegistryBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9248;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class DeferredRegister<T> {
    private final class_5321<? extends class_2378<T>> registryKey;
    private final String namespace;
    private final Map<DeferredHolder<T, ? extends T>, Supplier<? extends T>> entries = new LinkedHashMap<DeferredHolder<T, ? extends T>, Supplier<? extends T>>();
    private final Set<DeferredHolder<T, ? extends T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    private final Map<class_2960, class_2960> aliases = new HashMap<class_2960, class_2960>();
    @Nullable
    private class_2378<T> customRegistry;
    @Nullable
    private RegistryHolder<T> registryHolder;
    private boolean seenRegisterEvent = false;
    private boolean seenNewRegistryEvent = false;
    private boolean registeredEventBus = false;

    public static <T> DeferredRegister<T> create(class_2378<T> registry, String namespace) {
        return new DeferredRegister<T>(registry.method_30517(), namespace);
    }

    public static <T> DeferredRegister<T> create(class_5321<? extends class_2378<T>> key, String namespace) {
        return new DeferredRegister<T>(key, namespace);
    }

    public static <B> DeferredRegister<B> create(class_2960 registryName, String modid) {
        return new DeferredRegister(class_5321.method_29180((class_2960)registryName), modid);
    }

    public static Items createItems(String modid) {
        return new Items(modid);
    }

    public static Blocks createBlocks(String modid) {
        return new Blocks(modid);
    }

    public static DataComponents createDataComponents(String modid) {
        return new DataComponents(modid);
    }

    protected DeferredRegister(class_5321<? extends class_2378<T>> registryKey, String namespace) {
        this.registryKey = Objects.requireNonNull(registryKey);
        this.namespace = Objects.requireNonNull(namespace);
    }

    public <I extends T> DeferredHolder<T, I> register(String name, Supplier<? extends I> sup) {
        return this.register(name, (class_2960 key) -> sup.get());
    }

    public <I extends T> DeferredHolder<T, I> register(String name, Function<class_2960, ? extends I> func) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after RegisterEvent has been fired.");
        }
        Objects.requireNonNull(name);
        Objects.requireNonNull(func);
        class_2960 key = class_2960.method_60655((String)this.namespace, (String)name);
        DeferredHolder<T, I> ret = this.createHolder(this.registryKey, key);
        if (this.entries.putIfAbsent(ret, () -> func.apply(key)) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return ret;
    }

    protected <I extends T> DeferredHolder<T, I> createHolder(class_5321<? extends class_2378<T>> registryKey, class_2960 key) {
        return DeferredHolder.create(registryKey, key);
    }

    public class_2378<T> makeRegistry(Consumer<RegistryBuilder<T>> consumer) {
        return this.makeRegistry(this.registryKey.method_29177(), consumer);
    }

    public Supplier<class_2378<T>> getRegistry() {
        if (this.registryHolder == null) {
            this.registryHolder = new RegistryHolder(this.registryKey);
        }
        return this.registryHolder;
    }

    public class_6862<T> createTagKey(String path) {
        Objects.requireNonNull(path);
        return this.createTagKey(class_2960.method_60655((String)this.namespace, (String)path));
    }

    public class_6862<T> createTagKey(class_2960 location) {
        Objects.requireNonNull(location);
        return class_6862.method_40092(this.registryKey, (class_2960)location);
    }

    public void addAlias(class_2960 from, class_2960 to) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot add aliases to DeferredRegister after RegisterEvent has been fired.");
        }
        this.aliases.put(from, to);
    }

    public void register() {
        if (this.registeredEventBus) {
            throw new IllegalStateException("Cannot register DeferredRegister to more than one event bus.");
        }
        this.registeredEventBus = true;
        this.addRegistry();
        this.addEntries();
    }

    public Collection<DeferredHolder<T, ? extends T>> getEntries() {
        return this.entriesView;
    }

    public class_5321<? extends class_2378<T>> getRegistryKey() {
        return this.registryKey;
    }

    public class_2960 getRegistryName() {
        return this.registryKey.method_29177();
    }

    public String getNamespace() {
        return this.namespace;
    }

    private class_2378<T> makeRegistry(class_2960 registryName, Consumer<RegistryBuilder<T>> consumer) {
        if (registryName == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a registry name");
        }
        if (class_7923.field_41167.method_10250(registryName) || this.customRegistry != null) {
            throw new IllegalStateException("Cannot create a registry that already exists - " + String.valueOf(this.registryKey));
        }
        if (this.seenNewRegistryEvent) {
            throw new IllegalStateException("Cannot create a registry after NewRegistryEvent was fired");
        }
        RegistryBuilder registryBuilder = new RegistryBuilder(this.registryKey);
        consumer.accept(registryBuilder);
        this.customRegistry = registryBuilder.create();
        this.registryHolder = new RegistryHolder(this.registryKey);
        this.registryHolder.registry = this.customRegistry;
        return this.customRegistry;
    }

    private void addEntries() {
        this.seenRegisterEvent = true;
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(this.registryKey.method_29177());
        for (Map.Entry<DeferredHolder<T, T>, Supplier<T>> e : this.entries.entrySet()) {
            class_2378.method_10230((class_2378)registry, (class_2960)e.getKey().getId(), e.getValue().get());
            e.getKey().bind(false);
        }
    }

    private void addRegistry() {
        this.seenNewRegistryEvent = true;
        if (this.customRegistry != null) {
            RegistryAttributeHolder.get((class_5321)this.customRegistry.method_30517()).addAttribute(RegistryAttribute.MODDED);
            ((class_2385)class_7923.field_41167).method_10272(this.customRegistry.method_30517(), this.customRegistry, class_9248.field_49136);
        }
    }

    public static class Items
    extends DeferredRegister<class_1792> {
        protected Items(String namespace) {
            super(class_7924.field_41197, namespace);
        }

        public <I extends class_1792> DeferredItem<I> register(String name, Function<class_2960, ? extends I> func) {
            return (DeferredItem)super.register(name, func);
        }

        public <I extends class_1792> DeferredItem<I> register(String name, Supplier<? extends I> sup) {
            return this.register(name, (T key) -> (class_1792)sup.get());
        }

        public DeferredItem<class_1747> registerSimpleBlockItem(String name, Supplier<? extends class_2248> block, class_1792.class_1793 properties) {
            return this.register(name, (T key) -> new class_1747((class_2248)block.get(), properties));
        }

        public DeferredItem<class_1747> registerSimpleBlockItem(String name, Supplier<? extends class_2248> block) {
            return this.registerSimpleBlockItem(name, block, new class_1792.class_1793());
        }

        public DeferredItem<class_1747> registerSimpleBlockItem(class_6880<class_2248> block, class_1792.class_1793 properties) {
            return this.registerSimpleBlockItem(((class_5321)block.method_40230().orElseThrow()).method_29177().method_12832(), () -> block.comp_349(), properties);
        }

        public DeferredItem<class_1747> registerSimpleBlockItem(class_6880<class_2248> block) {
            return this.registerSimpleBlockItem(block, new class_1792.class_1793());
        }

        public <I extends class_1792> DeferredItem<I> registerItem(String name, Function<class_1792.class_1793, ? extends I> func, class_1792.class_1793 props) {
            return this.register(name, () -> (class_1792)func.apply(props));
        }

        public <I extends class_1792> DeferredItem<I> registerItem(String name, Function<class_1792.class_1793, ? extends I> func) {
            return this.registerItem(name, func, new class_1792.class_1793());
        }

        public DeferredItem<class_1792> registerSimpleItem(String name, class_1792.class_1793 props) {
            return this.registerItem(name, class_1792::new, props);
        }

        public DeferredItem<class_1792> registerSimpleItem(String name) {
            return this.registerItem(name, class_1792::new, new class_1792.class_1793());
        }

        protected <I extends class_1792> DeferredItem<I> createHolder(class_5321<? extends class_2378<class_1792>> registryKey, class_2960 key) {
            return DeferredItem.createItem((class_5321<class_1792>)class_5321.method_29179(registryKey, (class_2960)key));
        }
    }

    public static class Blocks
    extends DeferredRegister<class_2248> {
        protected Blocks(String namespace) {
            super(class_7924.field_41254, namespace);
        }

        public <B extends class_2248> DeferredBlock<B> register(String name, Function<class_2960, ? extends B> func) {
            return (DeferredBlock)super.register(name, func);
        }

        public <B extends class_2248> DeferredBlock<B> register(String name, Supplier<? extends B> sup) {
            return this.register(name, (T key) -> (class_2248)sup.get());
        }

        public <B extends class_2248> DeferredBlock<B> registerBlock(String name, Function<class_4970.class_2251, ? extends B> func, class_4970.class_2251 props) {
            return this.register(name, () -> (class_2248)func.apply(props));
        }

        public DeferredBlock<class_2248> registerSimpleBlock(String name, class_4970.class_2251 props) {
            return this.registerBlock(name, class_2248::new, props);
        }

        protected <I extends class_2248> DeferredBlock<I> createHolder(class_5321<? extends class_2378<class_2248>> registryKey, class_2960 key) {
            return DeferredBlock.createBlock((class_5321<class_2248>)class_5321.method_29179(registryKey, (class_2960)key));
        }
    }

    public static class DataComponents
    extends DeferredRegister<class_9331<?>> {
        protected DataComponents(String namespace) {
            super(class_7924.field_49659, namespace);
        }

        public <D> DeferredHolder<class_9331<?>, class_9331<D>> registerComponentType(String name, UnaryOperator<class_9331.class_9332<D>> builder) {
            return this.register(name, () -> ((class_9331.class_9332)builder.apply(class_9331.method_57873())).method_57880());
        }
    }

    private static class RegistryHolder<V>
    implements Supplier<class_2378<V>> {
        private final class_5321<? extends class_2378<V>> registryKey;
        private class_2378<V> registry = null;

        private RegistryHolder(class_5321<? extends class_2378<V>> registryKey) {
            this.registryKey = registryKey;
        }

        @Override
        @Nullable
        public class_2378<V> get() {
            if (this.registry == null) {
                this.registry = (class_2378)class_7923.field_41167.method_10223(this.registryKey.method_29177());
            }
            return this.registry;
        }
    }
}

