/*
 * Decompiled with CFR 0.152.
 */
package com.pam.brewcraft.config;

import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    private final Configuration config;
    private static final String CATEGORY_GENERAL = "general";
    private static final int defaultCropFoodRestore = 1;
    private static final double defaultSaturationSmall = 0.6;
    public static final double defaultAlcoholSaturation = 1.2;
    private static final double defaultCropGrowthSpeed = 0.0;
    private static final int defaultExperienceLevel = 21;
    public int cropfoodRestore;
    public float cropsaturationRestore;
    public static boolean cropsdropSeeds;
    public static float cropGrowthSpeed;
    public int seedrarity;
    public static int experiencelevelHealthRestore;
    public float alcoholsaturationRestore;
    public final HashMap<String, Boolean> seedDropFromGrass = new HashMap();

    public ConfigHandler(Configuration config) {
        this.config = config;
        this.initSettings();
    }

    private void initSettings() {
        this.config.load();
        this.initCropSettings();
        this.initSeedDropSettings();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void initCropSettings() {
        this.cropfoodRestore = this.config.get(CATEGORY_GENERAL, "cropfoodRestore", 1).getInt();
        this.cropsaturationRestore = (float)this.config.get(CATEGORY_GENERAL, "cropsaturationRestore", 0.6).getDouble();
        cropsdropSeeds = this.config.get(CATEGORY_GENERAL, "cropsdropSeeds", false).getBoolean();
        cropGrowthSpeed = (float)this.config.get(CATEGORY_GENERAL, "cropGrowthSpeed", 0.0, "Default: 0.0, This number is added/subtracted from normal fertile crop growth (3.0) and adjacent fertile crop growth (4.0).").getDouble();
        experiencelevelHealthRestore = this.config.get(CATEGORY_GENERAL, "experiencelevelHealthRestore", 21).getInt();
        this.alcoholsaturationRestore = (float)this.config.get(CATEGORY_GENERAL, "alcoholsaturationRestore", 1.2).getDouble();
    }

    private void initSeedDropSettings() {
        this.seedrarity = this.config.get(CATEGORY_GENERAL, "seedrarity", 1).getInt();
        this.initSeedDropFromGrassSetting("hopsseeddropfromgrass", "hops");
    }

    private void initSeedDropFromGrassSetting(String key, String item) {
        boolean doDrop = this.config.get(CATEGORY_GENERAL, key, true).getBoolean();
        this.seedDropFromGrass.put(item, doDrop);
    }
}

