/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArrayList;
import stanhebben.zenscript.type.casting.CastingRuleStaticMethod;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.type.iterator.IteratorIterable;
import stanhebben.zenscript.type.iterator.IteratorList;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;
import youyihj.zenutils.impl.zenscript.nat.ZenTypeJavaNative;

public class ZenTypeJavaNativeIterable
extends ZenTypeJavaNative {
    private static final IJavaMethod ITERABLE_SIZE = JavaMethod.get((ITypeRegistry)ZenTypeUtil.EMPTY_REGISTRY, Iterables.class, (String)"size", (Class[])new Class[]{Iterable.class});
    private static final IJavaMethod NEW_ARRAY_LIST_FROM_ITERABLE = JavaMethod.get((ITypeRegistry)ZenTypeUtil.EMPTY_REGISTRY, Lists.class, (String)"newArrayList", (Class[])new Class[]{Iterable.class});
    private final ZenType baseType;

    public ZenTypeJavaNativeIterable(Class<?> clazz, ZenType baseType, ITypeRegistry registry) {
        super(clazz, registry);
        this.baseType = baseType;
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        if (name.equals("length")) {
            return this.getMemberLength(position, environment, value);
        }
        return super.getMember(position, environment, value, name);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        if (operator == OperatorType.INDEXGET) {
            return this.indexGet(position, left, right);
        }
        return super.binary(position, environment, left, right, operator);
    }

    private IPartialExpression getMemberLength(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value) {
        return new ExpressionCallStatic(position, environment, ITERABLE_SIZE, new Expression[]{value.eval(environment)});
    }

    private Expression indexGet(ZenPosition position, final Expression array, final Expression index) {
        return new Expression(position){

            public void compile(boolean result, IEnvironmentMethod environment) {
                if (result) {
                    array.compile(true, environment);
                    index.compile(true, environment);
                    environment.getOutput().invokeStatic(Iterables.class, "get", Object.class, new Class[]{Iterable.class, Integer.TYPE});
                    environment.getOutput().checkCast(ZenTypeUtil.checkPrimitive((ZenType)this.getType()).toASMType().getInternalName());
                    if (ZenTypeUtil.isPrimitive((ZenType)this.getType())) {
                        ZenTypeUtil.checkPrimitive((ZenType)this.getType()).getCastingRule(this.getType(), (IEnvironmentGlobal)environment).compile(environment);
                    }
                }
            }

            public ZenType getType() {
                return ZenTypeJavaNativeIterable.this.baseType;
            }
        };
    }

    @Override
    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
        super.constructCastingRules(environment, rules, followCasters);
        rules.registerCastingRule((ZenType)new ZenTypeArrayList(this.baseType), (ICastingRule)new CastingRuleStaticMethod(NEW_ARRAY_LIST_FROM_ITERABLE));
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        if (numValues == 1) {
            return new IteratorIterable(methodOutput.getOutput(), this.baseType);
        }
        if (numValues == 2) {
            return new IteratorList(methodOutput.getOutput(), this.baseType);
        }
        return null;
    }
}

