/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.Type;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArithmeticUnary;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionCompareGeneric;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.casting.CastingRuleStaticMethod;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;
import youyihj.zenutils.impl.util.InternalUtils;
import youyihj.zenutils.impl.zenscript.nat.CastingRuleCoerced;
import youyihj.zenutils.impl.zenscript.nat.CraftTweakerBridge;
import youyihj.zenutils.impl.zenscript.nat.ExpressionNativeConstructorCall;
import youyihj.zenutils.impl.zenscript.nat.JavaNativeMemberSymbol;

public class ZenTypeJavaNative
extends ZenType {
    private final Class<?> clazz;
    private final Map<String, JavaNativeMemberSymbol> symbols = new HashMap<String, JavaNativeMemberSymbol>();
    private final List<ZenTypeJavaNative> superClasses;
    private static final IJavaMethod OBJECTS_EQUALS = JavaMethod.get((ITypeRegistry)ZenTypeUtil.EMPTY_REGISTRY, Objects.class, (String)"equals", (Class[])new Class[]{Object.class, Object.class});

    public ZenTypeJavaNative(Class<?> clazz, ITypeRegistry registry) {
        this.clazz = clazz;
        this.superClasses = Stream.concat(Stream.of(clazz.getSuperclass()), Arrays.stream(clazz.getInterfaces())).map(arg_0 -> ((ITypeRegistry)registry).getType(arg_0)).filter(ZenTypeJavaNative.class::isInstance).map(ZenTypeJavaNative.class::cast).collect(Collectors.toList());
    }

    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        environment.error(position, "no operator available");
        return new ExpressionInvalid(position);
    }

    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        environment.error(position, "no operator available");
        return new ExpressionInvalid(position);
    }

    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        environment.error(position, "no operator available");
        return new ExpressionInvalid(position);
    }

    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        if (Comparable.class.isAssignableFrom(this.clazz)) {
            ZenType canCompareType = environment.getType(InternalUtils.getSingleItfGenericVariable(this.clazz.asSubclass(Comparable.class), Comparable.class));
            if (right.getType().canCastImplicit(canCompareType, environment)) {
                return new ExpressionCompareGeneric(position, (Expression)new ExpressionCallVirtual(position, environment, JavaMethod.get((ITypeRegistry)environment, this.clazz, (String)"compareTo", (Class[])new Class[]{Object.class}), left, new Expression[]{right.cast(position, environment, canCompareType)}), type);
            }
        }
        if (type == CompareType.EQ) {
            return new ExpressionCallStatic(position, environment, OBJECTS_EQUALS, new Expression[]{left, right});
        }
        if (type == CompareType.NE) {
            return new ExpressionArithmeticUnary(position, OperatorType.NOT, (Expression)new ExpressionCallStatic(position, environment, OBJECTS_EQUALS, new Expression[]{left, right}));
        }
        environment.error(position, "can not compare " + type + " between " + left.getType().getName() + " and " + right.getType().getName());
        return new ExpressionInvalid(position);
    }

    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        Optional<Method> wrapperCaster;
        if ("wrapper".equals(name) && (wrapperCaster = CraftTweakerBridge.INSTANCE.getWrapperCaster(this.clazz)).isPresent()) {
            return new ExpressionCallStatic(position, environment, (IJavaMethod)new JavaMethod(wrapperCaster.get(), (ITypeRegistry)environment), new Expression[]{value.eval(environment)});
        }
        IPartialExpression member = this.getSymbol(name, environment, false).receiver(value).instance(position);
        if (member instanceof ExpressionInvalid) {
            IPartialExpression memberExpansion = this.memberExpansion(position, environment, value.eval(environment), name);
            return memberExpansion == null ? member : memberExpansion;
        }
        return member;
    }

    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return this.getSymbol(name, environment, true).instance(position);
    }

    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        Constructor<?>[] constructors;
        Expression[] actualArguments = receiver == null ? arguments : (Expression[])ArrayUtils.add((Object[])arguments, (int)0, (Object)receiver);
        for (Constructor<?> constructor : constructors = this.clazz.getConstructors()) {
            if (!this.canAcceptConstructor(constructor, environment, actualArguments)) continue;
            return new ExpressionNativeConstructorCall(position, constructor, environment, actualArguments);
        }
        environment.error(position, "no such constructor matched");
        return new ExpressionInvalid(position);
    }

    public ICastingRule getCastingRule(ZenType type, IEnvironmentGlobal environment) {
        ICastingRule castingRule = super.getCastingRule(type, environment);
        if (castingRule == null) {
            return new CastingRuleCoerced(this, type);
        }
        return castingRule;
    }

    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
        CraftTweakerBridge.INSTANCE.getWrapperCaster(this.clazz).ifPresent(it -> rules.registerCastingRule(environment.getType(it.getReturnType()), (ICastingRule)new CastingRuleStaticMethod((IJavaMethod)new JavaMethod(it, (ITypeRegistry)environment))));
    }

    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        return null;
    }

    public Class<?> toJavaClass() {
        return this.clazz;
    }

    public Type toASMType() {
        return Type.getType(this.clazz);
    }

    public int getNumberType() {
        return 0;
    }

    public String getSignature() {
        return ZenTypeUtil.signature(this.clazz);
    }

    public boolean isPointer() {
        return true;
    }

    public String getAnyClassName(IEnvironmentGlobal environment) {
        return this.getName() + "Any";
    }

    public String getName() {
        return "native." + this.clazz.getCanonicalName();
    }

    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    private boolean canAcceptConstructor(Constructor<?> constructor, IEnvironmentGlobal environment, Expression[] arguments) {
        Class<?>[] parameters = constructor.getParameterTypes();
        if (arguments.length != parameters.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i].getType().canCastImplicit(environment.getType(parameters[i]), environment)) continue;
            return false;
        }
        return true;
    }

    private JavaNativeMemberSymbol getSymbol(String name, IEnvironmentGlobal environment, boolean isStatic) {
        return this.symbols.computeIfAbsent(name, it -> JavaNativeMemberSymbol.of(environment, this.clazz, it, isStatic));
    }

    public IPartialExpression memberExpansion(ZenPosition position, IEnvironmentGlobal environment, Expression value, String member) {
        IPartialExpression expression = super.memberExpansion(position, environment, value, member);
        if (expression == null) {
            for (ZenTypeJavaNative superClass : this.superClasses) {
                expression = superClass.memberExpansion(position, environment, value, member);
                if (expression == null) continue;
                return expression;
            }
        }
        return expression;
    }
}

