/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public enum MCPReobfuscation {
    INSTANCE;

    private final CompletableFuture<Pair<Multimap<String, String>, Multimap<String, String>>> mappers = CompletableFuture.supplyAsync(this::init);

    public Field reobfField(Class<?> owner, String name) {
        Collection possibleNames = ((Multimap)this.mappers.join().getRight()).get((Object)name);
        for (String possibleSrgName : possibleNames) {
            try {
                return owner.getField(possibleSrgName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        try {
            return owner.getField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public Stream<Method> reobfMethodOverloads(Class<?> owner, String name) {
        ImmutableList possibleNames = ImmutableList.builder().addAll((Iterable)((Multimap)this.mappers.join().getLeft()).get((Object)name)).add((Object)name).build();
        return Arrays.stream(owner.getMethods()).filter(arg_0 -> MCPReobfuscation.lambda$reobfMethodOverloads$0((Collection)possibleNames, arg_0));
    }

    public Method reobfMethod(Class<?> owner, String name) {
        return this.reobfMethodOverloads(owner, name).findFirst().orElse(null);
    }

    private Pair<Multimap<String, String>, Multimap<String, String>> init() {
        HashMultimap methodMap = HashMultimap.create();
        HashMultimap fieldMap = HashMultimap.create();
        Path localMapping = Paths.get("config", "mcp_stable-39-1.12.zip");
        String remoteMapping = "https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_stable/39-1.12/mcp_stable-39-1.12.zip";
        if (!Files.exists(localMapping, new LinkOption[0])) {
            try {
                URL url = new URL(remoteMapping);
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(30000);
                urlConnection.setReadTimeout(30000);
                Files.copy(url.openStream(), localMapping, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to download mcp mapping, try download it manually to `config/mcp_stable-39-1.12.zip`, uri: " + remoteMapping, e);
            }
        }
        try (FileSystem zipFs = FileSystems.newFileSystem(URI.create("jar:file:" + localMapping.toUri().getPath().replace(" ", "%20")), Collections.emptyMap());){
            try (Stream<String> methodStream = Files.lines(zipFs.getPath("methods.csv", new String[0]));){
                methodStream.skip(1L).map(it -> it.split(",")).forEach(arg_0 -> MCPReobfuscation.lambda$init$2((Multimap)methodMap, arg_0));
            }
            methodStream = Files.lines(zipFs.getPath("fields.csv", new String[0]));
            var8_12 = null;
            try {
                methodStream.skip(1L).map(it -> it.split(",")).forEach(arg_0 -> MCPReobfuscation.lambda$init$4((Multimap)fieldMap, arg_0));
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (methodStream != null) {
                    if (var8_12 != null) {
                        try {
                            methodStream.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        methodStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read mcp mapping", e);
        }
        return Pair.of((Object)methodMap, (Object)fieldMap);
    }

    private static /* synthetic */ void lambda$init$4(Multimap fieldMap, String[] it) {
        fieldMap.put((Object)it[1], (Object)it[0]);
    }

    private static /* synthetic */ void lambda$init$2(Multimap methodMap, String[] it) {
        methodMap.put((Object)it[1], (Object)it[0]);
    }

    private static /* synthetic */ boolean lambda$reobfMethodOverloads$0(Collection possibleNames, Method it) {
        return possibleNames.contains(it.getName());
    }
}

