/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.expression.partial.PartialType;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import youyihj.zenutils.impl.util.Either;
import youyihj.zenutils.impl.zenscript.nat.MCPReobfuscation;
import youyihj.zenutils.impl.zenscript.nat.PartialJavaNativeMember;

public class JavaNativeMemberSymbol
implements IZenSymbol {
    private final String name;
    private final Class<?> owner;
    private final IEnvironmentGlobal environment;
    private final boolean isStatic;
    private final List<IJavaMethod> methods;
    private final Either<Method, Field> getter;
    private final Either<Method, Field> setter;
    private final IPartialExpression receiver;

    private JavaNativeMemberSymbol(IEnvironmentGlobal environment, Class<?> owner, String name, boolean isStatic, IPartialExpression receiver) {
        this.name = name;
        this.environment = environment;
        this.owner = owner;
        this.isStatic = isStatic;
        this.receiver = receiver;
        this.methods = MCPReobfuscation.INSTANCE.reobfMethodOverloads(owner, name).filter(it -> this.validateModifier(it.getModifiers())).map(it -> JavaMethod.get((ITypeRegistry)environment, (Method)it)).collect(Collectors.toList());
        this.getter = Either.left(MCPReobfuscation.INSTANCE.reobfMethod(owner, "get" + StringUtils.capitalize((String)name))).validateLeft(this::validateGetter).orElseLeft(() -> MCPReobfuscation.INSTANCE.reobfMethod(owner, "is" + StringUtils.capitalize((String)name))).validateLeft(this::validateGetter).orElseRight(() -> MCPReobfuscation.INSTANCE.reobfField(owner, name)).validateRight(this::validateFieldGet);
        this.setter = Either.left(MCPReobfuscation.INSTANCE.reobfMethod(owner, "set" + StringUtils.capitalize((String)name))).validateLeft(this::validateSetter).orElseRight(() -> MCPReobfuscation.INSTANCE.reobfField(owner, name)).validateRight(this::validateFieldSet);
    }

    public static JavaNativeMemberSymbol of(IEnvironmentGlobal environment, Class<?> owner, String name, boolean isStatic) {
        return new JavaNativeMemberSymbol(environment, owner, name, isStatic, null);
    }

    public JavaNativeMemberSymbol receiver(IPartialExpression instanceValue) {
        if (!this.isStatic) {
            return new JavaNativeMemberSymbol(this.environment, this.owner, this.name, false, instanceValue);
        }
        throw new IllegalStateException("set instance to static symbol");
    }

    public IPartialExpression instance(ZenPosition position) {
        if (!this.isStatic && this.receiver == null) {
            throw new IllegalStateException("missing instance value of virtual symbol");
        }
        if (this.getter.isEmpty() && this.setter.isEmpty() && this.methods.isEmpty()) {
            if (this.isStatic) {
                try {
                    return new PartialType(position, this.environment.getType(Class.forName(this.owner.getName() + "$" + this.name)));
                }
                catch (ClassNotFoundException e) {
                    this.environment.error("no such static member or nested class: " + this.owner.getName() + "." + this.name);
                }
            }
        } else {
            return new PartialJavaNativeMember(position, this.name, this.methods, this.receiver, this.environment, this.owner, this.getter, this.setter);
        }
        return new ExpressionInvalid(position);
    }

    private boolean validateGetter(Method method) {
        return method.getParameterCount() == 0 && this.validateModifier(method.getModifiers());
    }

    private boolean validateSetter(Method method) {
        return method.getParameterCount() == 1 && this.validateModifier(method.getModifiers());
    }

    private boolean validateFieldGet(Field field) {
        return this.validateModifier(field.getModifiers());
    }

    private boolean validateFieldSet(Field field) {
        return this.validateModifier(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }

    private boolean validateModifier(int modifier) {
        return Modifier.isStatic(modifier) == this.isStatic;
    }
}

