/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionNativeConstructorCall
extends Expression {
    private final Constructor<?> constructor;
    private final IEnvironmentGlobal environment;
    private final Expression[] arguments;

    public ExpressionNativeConstructorCall(ZenPosition position, Constructor<?> constructor, IEnvironmentGlobal environment, Expression[] arguments) {
        super(position);
        this.constructor = constructor;
        this.environment = environment;
        this.arguments = arguments;
    }

    public void compile(boolean result, IEnvironmentMethod environment) {
        MethodOutput output = environment.getOutput();
        output.newObject(this.getType().toJavaClass());
        output.dup();
        for (int i = 0; i < this.arguments.length; ++i) {
            Expression argument = this.arguments[i];
            argument.cast(this.getPosition(), (IEnvironmentGlobal)environment, environment.getType(this.constructor.getParameterTypes()[i])).compile(true, environment);
        }
        String signatureBuilder = Arrays.stream(this.constructor.getParameterTypes()).map(Type::getDescriptor).collect(Collectors.joining("", "(", ")V"));
        output.invokeSpecial(Type.getInternalName(this.constructor.getDeclaringClass()), "<init>", signatureBuilder);
        if (!result) {
            output.pop();
        }
    }

    public ZenType getType() {
        return this.environment.getType(this.constructor.getDeclaringClass());
    }
}

