/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.zenscript.nat;

import java.lang.reflect.Method;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;

public class DelegatedExpressionCallStatic
extends ExpressionCallStatic {
    private final ExpressionCallStatic interfaceStaticMethodWrapper;
    private final String wrapperClassName;
    private final JavaMethod method;

    public DelegatedExpressionCallStatic(ZenPosition position, IEnvironmentGlobal environment, IJavaMethod method, Expression ... arguments) {
        super(position, environment, method, arguments);
        if (method instanceof JavaMethod && ((JavaMethod)method).getOwner().isInterface()) {
            this.method = (JavaMethod)method;
            this.wrapperClassName = this.getWrapperClassName(this.method);
            this.interfaceStaticMethodWrapper = new ExpressionCallStatic(position, environment, JavaMethod.getStatic((String)this.wrapperClassName, (String)"invoke", (ZenType)method.getReturnType(), (ZenType[])method.getParameterTypes()), new Expression[0]);
        } else {
            this.interfaceStaticMethodWrapper = null;
            this.wrapperClassName = null;
            this.method = null;
        }
    }

    public void compile(boolean result, IEnvironmentMethod environment) {
        if (this.interfaceStaticMethodWrapper == null) {
            super.compile(result, environment);
        } else {
            this.interfaceStaticMethodWrapper.compile(result, environment);
            if (!environment.containsClass(this.wrapperClassName)) {
                environment.putClass(this.wrapperClassName, this.compileWrapperClass(this.method));
            }
        }
    }

    private String getWrapperClassName(JavaMethod method) {
        StringBuilder sb = new StringBuilder(method.getOwner().getName().replace('.', '_'));
        sb.append('$');
        sb.append(method.getMethod().getName());
        sb.append('$');
        for (ZenType parameterType : method.getParameterTypes()) {
            sb.append(parameterType.getNameForInterfaceSignature());
        }
        return sb.toString();
    }

    private byte[] compileWrapperClass(JavaMethod method) {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(52, 17, this.wrapperClassName, null, "java/lang/Object", null);
        MethodVisitor constructor = cw.visitMethod(2, "<init>", "()V", null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        constructor.visitInsn(177);
        constructor.visitMaxs(-1, -1);
        constructor.visitEnd();
        MethodVisitor invoke = cw.visitMethod(9, "invoke", Type.getMethodDescriptor((Method)method.getMethod()), null, null);
        int varIndex = 0;
        for (ZenType parameterType : method.getParameterTypes()) {
            Type asmType = parameterType.toASMType();
            invoke.visitVarInsn(asmType.getOpcode(21), varIndex);
            varIndex += asmType.getSize();
        }
        invoke.visitMethodInsn(184, Type.getInternalName((Class)method.getOwner()), method.getMethod().getName(), Type.getMethodDescriptor((Method)method.getMethod()), true);
        invoke.visitInsn(method.getReturnType().toASMType().getOpcode(172));
        invoke.visitMaxs(-1, -1);
        invoke.visitEnd();
        return cw.toByteArray();
    }
}

