/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util.catenation.persistence;

import com.mojang.authlib.GameProfile;
import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataLong;
import crafttweaker.api.data.IData;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IWorld;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.persistence.BuiltinObjectHolderTypes;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationObjectHolder;

public class PlayerObjectHolder
implements ICatenationObjectHolder<IPlayer> {
    private IPlayer player;
    private UUID uuid;

    @Override
    public ICatenationObjectHolder.Type<IPlayer> getType() {
        return BuiltinObjectHolderTypes.PLAYER;
    }

    @Override
    public IData serializeToData() {
        return new DataList(Arrays.asList(new DataLong(this.uuid.getMostSignificantBits()), new DataLong(this.uuid.getLeastSignificantBits())), true);
    }

    @Override
    public void deserializeFromData(IData data) {
        List list = data.asList();
        this.uuid = new UUID(((IData)list.get(0)).asLong(), ((IData)list.get(1)).asLong());
    }

    @Override
    public void receiveObject(IPlayer object) {
        if (Objects.equals(EntityPlayer.func_146094_a((GameProfile)CraftTweakerMC.getPlayer((IPlayer)object).func_146103_bH()), this.uuid)) {
            this.player = object;
        }
    }

    @Override
    public IPlayer getValue() {
        return this.player;
    }

    @Override
    public void setValue(IPlayer value) {
        this.player = value;
        this.uuid = EntityPlayer.func_146094_a((GameProfile)CraftTweakerMC.getPlayer((IPlayer)this.player).func_146103_bH());
    }

    @Override
    public ICatenationObjectHolder.ValidationResult validate(Catenation catenation) {
        return this.player != null && CraftTweakerMC.getWorld((IWorld)catenation.getWorld()).field_73010_i.contains(CraftTweakerMC.getPlayer((IPlayer)this.player)) ? ICatenationObjectHolder.ValidationResult.VALID : ICatenationObjectHolder.ValidationResult.INVALID_PAUSE;
    }

    @Override
    public void invalidate() {
        this.player = null;
    }
}

