/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util.catenation.persistence;

import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataLong;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.persistence.BuiltinObjectHolderTypes;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationObjectHolder;

public class EntityObjectHolder
implements ICatenationObjectHolder<IEntity> {
    private IEntity entity;
    private UUID uuid;

    @Override
    public ICatenationObjectHolder.Type<IEntity> getType() {
        return BuiltinObjectHolderTypes.ENTITY;
    }

    @Override
    public IData serializeToData() {
        return new DataList(Arrays.asList(new DataLong(this.uuid.getMostSignificantBits()), new DataLong(this.uuid.getLeastSignificantBits())), true);
    }

    @Override
    public void deserializeFromData(IData data) {
        List list = data.asList();
        this.uuid = new UUID(((IData)list.get(0)).asLong(), ((IData)list.get(1)).asLong());
    }

    @Override
    public void receiveObject(IEntity object) {
        if (Objects.equals(this.uuid, CraftTweakerMC.getEntity((IEntity)object).func_110124_au())) {
            this.entity = object;
        }
    }

    @Override
    public IEntity getValue() {
        return this.entity;
    }

    @Override
    public void setValue(IEntity value) {
        this.entity = value;
        this.uuid = CraftTweakerMC.getEntity((IEntity)value).func_110124_au();
    }

    @Override
    public void invalidate() {
        this.entity = null;
    }

    @Override
    public ICatenationObjectHolder.ValidationResult validate(Catenation catenation) {
        if (this.entity != null) {
            if (!this.entity.isAlive()) {
                return ICatenationObjectHolder.ValidationResult.INVALID_STOP;
            }
            if (!CraftTweakerMC.getEntity((IEntity)this.entity).isAddedToWorld()) {
                return ICatenationObjectHolder.ValidationResult.INVALID_PAUSE;
            }
            return ICatenationObjectHolder.ValidationResult.VALID;
        }
        return ICatenationObjectHolder.ValidationResult.INVALID_PAUSE;
    }
}

