/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util.catenation;

import java.util.ArrayDeque;
import java.util.Queue;
import youyihj.zenutils.api.util.catenation.ICatenationTask;
import youyihj.zenutils.api.util.catenation.ICatenationTaskQueueBuilder;
import youyihj.zenutils.api.util.catenation.ICatenationTaskQueueBuilderConsumer;
import youyihj.zenutils.api.util.catenation.ITimerHandler;
import youyihj.zenutils.api.util.catenation.IWorldCondition;
import youyihj.zenutils.api.util.catenation.IWorldFunction;
import youyihj.zenutils.impl.util.catenation.InstantTask;
import youyihj.zenutils.impl.util.catenation.RepeatTask;
import youyihj.zenutils.impl.util.catenation.SleepTask;
import youyihj.zenutils.impl.util.catenation.SleepUntilTask;
import youyihj.zenutils.impl.util.catenation.TimerTask;

public class CatenationTaskQueueBuilder
implements ICatenationTaskQueueBuilder {
    private final Queue<ICatenationTask> tasks = new ArrayDeque<ICatenationTask>();

    @Override
    public ICatenationTaskQueueBuilder addTask(ICatenationTask task) {
        this.tasks.add(task);
        return this;
    }

    @Override
    public Queue<ICatenationTask> build() {
        return this.tasks;
    }

    @Override
    public ICatenationTaskQueueBuilder run(IWorldFunction function) {
        return this.addTask(new InstantTask(function));
    }

    @Override
    public ICatenationTaskQueueBuilder sleep(long ticks) {
        return this.addTask(new SleepTask(ticks));
    }

    @Override
    public ICatenationTaskQueueBuilder sleepUntil(IWorldCondition condition) {
        return this.addTask(new SleepUntilTask(condition));
    }

    @Override
    public ICatenationTaskQueueBuilder customTimer(long duration, ITimerHandler handler) {
        return this.addTask(new TimerTask(duration, handler));
    }

    @Override
    public ICatenationTaskQueueBuilder repeat(int times, ICatenationTaskQueueBuilderConsumer taskQueueBuilderConsumer) {
        return this.addTask(new RepeatTask(taskQueueBuilderConsumer, times));
    }
}

