/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.event.MTEventManager;
import crafttweaker.util.EventList;
import crafttweaker.zenscript.GlobalRegistry;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.type.expand.ZenExpandMember;
import stanhebben.zenscript.type.natives.JavaMethod;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.impl.runtime.InvalidCraftTweakerVersionException;
import youyihj.zenutils.impl.runtime.ScriptStatus;
import youyihj.zenutils.impl.util.IVersionChecker;
import youyihj.zenutils.impl.util.ReflectUtils;

public final class InternalUtils {
    private static final List<EventList> ALL_EVENT_LISTS = new ArrayList<EventList>();
    private static ScriptStatus scriptStatus = ScriptStatus.INIT;

    private InternalUtils() {
    }

    public static void checkDataMap(IData data) {
        Preconditions.checkArgument((boolean)(data instanceof DataMap), (Object)"data argument must be DataMap");
    }

    public static void checkCraftTweakerVersion(String requiredVersion, IVersionChecker versionChecker) {
        boolean result = versionChecker.getResult();
        if (!result) {
            throw new InvalidCraftTweakerVersionException(requiredVersion);
        }
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            clazz.getMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isContentTweakerInstalled() {
        return Loader.isModLoaded((String)"contenttweaker");
    }

    public static void scanAllEventLists() throws NoSuchFieldException {
        try {
            ALL_EVENT_LISTS.addAll(ReflectUtils.getAllFieldsWithClass(MTEventManager.class, EventList.class, CraftTweakerAPI.events));
        }
        catch (IllegalAccessException e) {
            ZenUtils.forgeLogger.error("Failed to get vanilla CraftTweaker Event List!", (Throwable)e);
        }
        Field membersField = ReflectUtils.removePrivate(TypeExpansion.class, "members");
        Field methodsField = ReflectUtils.removePrivate(ZenExpandMember.class, "methods");
        TypeExpansion eventMangerExpansion = (TypeExpansion)GlobalRegistry.getExpansions().get("crafttweaker.events.IEventManager");
        if (eventMangerExpansion == null) {
            return;
        }
        try {
            Map expandMembers = (Map)membersField.get(eventMangerExpansion);
            ArrayList<Class> lookupClasses = new ArrayList<Class>();
            for (ZenExpandMember expandMember : expandMembers.values()) {
                Class owner;
                Object javaMethod;
                Class<JavaMethod> javaMethodClass;
                List list = (List)methodsField.get(expandMember);
                if (list.isEmpty() || !(javaMethodClass = JavaMethod.class).isInstance(javaMethod = list.get(0)) || lookupClasses.contains(owner = ((JavaMethod)javaMethodClass.cast(javaMethod)).getOwner())) continue;
                lookupClasses.add(owner);
                ALL_EVENT_LISTS.addAll(ReflectUtils.getAllFieldsWithClass(owner, EventList.class, null));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
            ZenUtils.forgeLogger.error("Failed to get event manager expansions.", (Throwable)e);
        }
    }

    public static List<EventList> getAllEventLists() {
        return ImmutableList.copyOf(ALL_EVENT_LISTS);
    }

    public static void setScriptStatus(ScriptStatus scriptStatus) {
        InternalUtils.scriptStatus = scriptStatus;
    }

    public static ScriptStatus getScriptStatus() {
        return scriptStatus;
    }

    public static Object cloneArray(Object array) {
        Class<?> arrayClass = array.getClass();
        Preconditions.checkArgument((boolean)arrayClass.isArray(), (Object)"argument should be an array");
        try {
            return MethodHandles.publicLookup().findVirtual(arrayClass, "clone", MethodType.methodType(Object.class)).bindTo(array).invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to clone the array", e);
        }
    }

    public static <T extends U, U> Type getSingleItfGenericVariable(Class<T> type, Class<U> itf) {
        return TypeToken.of(type).getSupertype(itf).resolveType(itf.getTypeParameters()[0]).getType();
    }
}

