/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.runtime;

import crafttweaker.api.logger.MTLogger;
import crafttweaker.api.player.IPlayer;
import crafttweaker.runtime.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import youyihj.zenutils.api.logger.ICleanableLogger;
import youyihj.zenutils.api.logger.LogLevel;
import youyihj.zenutils.api.logger.LogOption;

public class ZenUtilsLogger
extends MTLogger
implements ICleanableLogger {
    private boolean hasError = false;
    private final List<ILogger> loggers = new ArrayList<ILogger>();
    private final List<String> messagesToSendPlayer = new ArrayList<String>();
    private final List<IPlayer> playerList = new ArrayList<IPlayer>();
    private LogOption logOption = new LogOption();

    public void addLogger(ILogger logger) {
        this.loggers.add(logger);
    }

    public void removeLogger(ILogger logger) {
        this.loggers.remove(logger);
    }

    public void addPlayer(IPlayer player) {
        this.playerList.add(player);
        this.logPlayer(player);
    }

    public void removePlayer(IPlayer player) {
        this.playerList.remove(player);
    }

    public void clear() {
        this.messagesToSendPlayer.clear();
        this.logOption = new LogOption();
        this.hasError = false;
    }

    public void logCommand(String message) {
        this.loggers.forEach(logger -> logger.logCommand(message));
    }

    public void logInfo(String message) {
        this.log(LogLevel.INFO, message, null, logger -> logger.logInfo(message));
    }

    public void logWarning(String message) {
        this.log(LogLevel.WARNING, message, null, logger -> logger.logWarning(message));
    }

    public void logError(String message) {
        this.log(LogLevel.ERROR, message, null, logger -> logger.logError(message));
    }

    public void logError(String message, Throwable exception) {
        this.log(LogLevel.FATAL, message, exception, logger -> logger.logError(message, exception));
    }

    public void logPlayer(IPlayer player) {
        this.messagesToSendPlayer.forEach(arg_0 -> ((IPlayer)player).sendChat(arg_0));
    }

    public void logDefault(String message) {
        this.log(LogLevel.TRACE, message, null, logger -> logger.logDefault(message));
    }

    public boolean isLogDisabled() {
        return this.logOption.getMinLogLevel().compareTo(LogLevel.TRACE) > 0;
    }

    public void setLogDisabled(boolean logDisabled) {
        if (!this.isLogDisabled()) {
            this.logOption.setMinLogLevel(LogLevel.INFO);
        }
    }

    @Override
    public void clean() {
        this.messagesToSendPlayer.clear();
        this.loggers.stream().filter(ICleanableLogger.class::isInstance).map(ICleanableLogger.class::cast).forEach(ICleanableLogger::clean);
    }

    private void log(LogLevel logLevel, String message, Throwable exception, Consumer<ILogger> loggerConsumer) {
        if (this.logOption.isBlock(logLevel, message != null ? message : "")) {
            return;
        }
        this.loggers.forEach(loggerConsumer);
        if (logLevel.compareTo(LogLevel.ERROR) >= 0) {
            this.hasError = true;
        }
        if (logLevel.isLogPlayer()) {
            if (this.playerList.isEmpty()) {
                this.messagesToSendPlayer.add(logLevel.getTextFormatting() + this.getMessageToSendPlayer(message, exception));
            } else {
                this.playerList.forEach(it -> it.sendChat(logLevel.getTextFormatting() + this.getMessageToSendPlayer(message, exception)));
            }
        }
    }

    public String getMessageToSendPlayer(String message, Throwable exception) {
        if (exception == null) {
            return message;
        }
        if (message == null) {
            return String.valueOf(exception);
        }
        if (exception.getMessage() != null && message.endsWith(exception.getMessage())) {
            return message.substring(0, message.length() - exception.getMessage().length()) + exception;
        }
        return message + ", caused by " + exception;
    }

    public LogOption getLogOption() {
        return this.logOption;
    }

    public boolean hasError() {
        return this.hasError;
    }
}

