/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.runtime;

import crafttweaker.api.player.IPlayer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalTime;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import youyihj.zenutils.api.logger.ICleanableLogger;
import youyihj.zenutils.api.logger.LogLevel;

public class ZenUtilsFileLogger
implements ICleanableLogger {
    private final Path output;
    private PrintWriter printWriter;
    private boolean disableTrace;

    public ZenUtilsFileLogger(Path output) {
        this.output = output;
        this.openWriter();
    }

    public void logCommand(String message) {
        this.printWriter.println(TextFormatting.func_110646_a((String)message));
    }

    public void logInfo(String message) {
        this.log(LogLevel.INFO, message);
    }

    public void logWarning(String message) {
        this.log(LogLevel.WARNING, message);
    }

    public void logError(String message) {
        this.log(LogLevel.ERROR, message);
    }

    public void logError(String message, Throwable exception) {
        this.log(LogLevel.FATAL, message);
        if (exception != null) {
            exception.printStackTrace(this.printWriter);
        }
    }

    public void logPlayer(IPlayer player) {
    }

    public void logDefault(String message) {
        if (!this.disableTrace) {
            this.log(LogLevel.TRACE, message);
        }
    }

    public boolean isLogDisabled() {
        return this.disableTrace;
    }

    public void setLogDisabled(boolean logDisabled) {
        this.disableTrace = logDisabled;
    }

    @Override
    public void clean() {
        this.printWriter.close();
        this.openWriter();
        this.log(LogLevel.TRACE, "Requested to clean log at " + LocalTime.now());
    }

    private void log(LogLevel level, String message) {
        this.printWriter.printf("[%s][%s][%s] %s", new Object[]{Loader.instance().getLoaderState(), FMLCommonHandler.instance().getEffectiveSide(), level, TextFormatting.func_110646_a((String)message)});
        this.printWriter.println();
    }

    private void openWriter() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.output, StandardCharsets.UTF_8, new OpenOption[0]);
            this.printWriter = new PrintWriter((Writer)writer, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open log file " + this.output);
        }
    }
}

