/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.reload;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.runtime.ScriptLoader;
import java.util.List;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.logger.LogLevel;
import youyihj.zenutils.impl.runtime.ZenUtilsLogger;

public class ScriptReloader {
    private static final String SCRIPT_LOADER_NAME = "reloadable";
    private static final List<String> reloadableLoaders = Lists.newArrayList((Object[])new String[]{"reloadable"});

    public static void addReloadableLoader(String loaderName) {
        if (!reloadableLoaders.contains(loaderName)) {
            reloadableLoaders.add(loaderName);
        }
    }

    public static List<String> getReloadableLoaders() {
        return reloadableLoaders;
    }

    static boolean reloadScripts() {
        ScriptLoader loader = new ScriptLoader(reloadableLoaders.toArray(new String[0]));
        ZenUtilsLogger logger = ZenUtils.crafttweakerLogger;
        logger.clear();
        logger.getLogOption().setMinLogLevel(LogLevel.WARNING);
        CraftTweakerAPI.tweaker.loadScript(true, loader);
        if (loader.getLoaderStage() == ScriptLoader.LoaderStage.ERROR || logger.hasError()) {
            return false;
        }
        loader.setLoaderStage(ScriptLoader.LoaderStage.NOT_LOADED);
        logger.clear();
        CraftTweakerAPI.tweaker.loadScript(false, loader);
        return loader.getLoaderStage() != ScriptLoader.LoaderStage.ERROR;
    }
}

