/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.reload;

import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import stanhebben.zenscript.ZenModule;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.reload.ScriptReloadEvent;
import youyihj.zenutils.impl.reload.ScriptReloader;
import youyihj.zenutils.impl.runtime.ScriptStatus;
import youyihj.zenutils.impl.util.InternalUtils;

public class ReloadCommand
extends CraftTweakerCommand {
    public ReloadCommand() {
        super("reload");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{SpecialMessagesChat.getClickableCommandText((String)(TextFormatting.DARK_GREEN + "/ct reload"), (String)"/ct reload", (boolean)true), SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_AQUA + "Reload reloadable scripts"))});
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (server.func_71262_S()) {
            sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_RED + "The command only can be run in integrated server (SinglePlayer)!")));
            return;
        }
        if (args.length != 0 && "clean".equals(args[0])) {
            ZenUtils.crafttweakerLogger.clean();
        }
        ReloadCommand.reloadScripts(sender);
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.singletonList("clean");
    }

    public static void reloadScripts(ICommandSender requester) {
        requester.func_145747_a(SpecialMessagesChat.getNormalMessage((String)(TextFormatting.AQUA + "Beginning reload scripts")));
        if (!Loader.isModLoaded((String)"zenrecipereloading")) {
            requester.func_145747_a(SpecialMessagesChat.getNormalMessage((String)(TextFormatting.YELLOW + "Most recipe modifications are not reloadable, they will be ignored.")));
        }
        ZenUtils.tweaker.freezeActionApplying();
        ZenModule.loadedClasses.clear();
        ZenUtils.crafttweakerLogger.clear();
        InternalUtils.setScriptStatus(ScriptStatus.RELOAD);
        MinecraftForge.EVENT_BUS.post((Event)new ScriptReloadEvent.Pre(requester));
        boolean successful = ScriptReloader.reloadScripts();
        if (successful) {
            requester.func_145747_a(SpecialMessagesChat.getNormalMessage((String)"Reloaded successfully"));
        } else {
            requester.func_145747_a(SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_RED + "Failed to reload scripts")));
        }
        MinecraftForge.EVENT_BUS.post((Event)new ScriptReloadEvent.Post(requester));
        InternalUtils.setScriptStatus(ScriptStatus.STARTED);
    }
}

