/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.player;

import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.ForgeHooks;

public class InteractBlockContext {
    private final Supplier<RayTraceResult> rayTraceResult;
    private BlockPos pos;
    private EnumFacing side;
    private float hitX;
    private float hitY;
    private float hitZ;

    public InteractBlockContext(EntityPlayer player, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        double reachDistance = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        this.rayTraceResult = Suppliers.memoize(() -> ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)reachDistance));
        this.pos = pos;
        this.side = side;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    public InteractBlockContext(EntityPlayer player, BlockPos pos, EnumFacing side) {
        this(player, pos, side, -1.0f, -1.0f, -1.0f);
    }

    public BlockPos getPos() {
        if (this.pos == null) {
            if (this.rayTraceResult.get().field_72313_a == RayTraceResult.Type.MISS) {
                throw new MissingParameterException("Player doesn't target at any block, please define position explicitly");
            }
            this.pos = this.rayTraceResult.get().func_178782_a();
        }
        return this.pos;
    }

    public EnumFacing getSide() {
        if (this.side == null) {
            if (!Objects.equals(this.getPos(), this.rayTraceResult.get().func_178782_a())) {
                throw new MissingParameterException("Player doesn't target at the given position, please define facing explicitly");
            }
            this.side = this.rayTraceResult.get().field_178784_b;
        }
        return this.side;
    }

    public float getHitX() {
        if (this.hitX == -1.0f) {
            if (!Objects.equals(this.getPos(), this.rayTraceResult.get().func_178782_a())) {
                throw new MissingParameterException("Player doesn't target at the given position, please define hitX explicitly");
            }
            this.hitX = (float)(this.rayTraceResult.get().field_72307_f.field_72450_a - (double)this.getPos().func_177958_n());
        }
        return this.hitX;
    }

    public float getHitY() {
        if (this.hitY == -1.0f) {
            if (!Objects.equals(this.getPos(), this.rayTraceResult.get().func_178782_a())) {
                throw new MissingParameterException("Player doesn't target at the given position, please define hitY explicitly");
            }
            this.hitY = (float)(this.rayTraceResult.get().field_72307_f.field_72448_b - (double)this.getPos().func_177956_o());
        }
        return this.hitY;
    }

    public float getHitZ() {
        if (this.hitZ == -1.0f) {
            if (!Objects.equals(this.getPos(), this.rayTraceResult.get().func_178782_a())) {
                throw new MissingParameterException("Player doesn't target at the given position, please define hitZ explicitly");
            }
            this.hitZ = (float)(this.rayTraceResult.get().field_72307_f.field_72449_c - (double)this.getPos().func_177952_p());
        }
        return this.hitZ;
    }

    public static class MissingParameterException
    extends RuntimeException {
        public MissingParameterException(String message) {
            super(message);
        }
    }
}

