/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.event;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.util.IEventHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.impl.event.EventHandlerRegisterAction;
import youyihj.zenutils.impl.event.EventHandlerRegisterException;
import youyihj.zenutils.impl.util.InternalUtils;

public class GenericEventManagerImpl {
    private static final Type EVENT_HANDLER_TYPE_VARIABLE;
    private static final int MAIN_EVENT_BUS_ID = 0;

    public static <T> void register(IEventHandler<T> eventHandler, EventPriority priority, boolean receiveCanceled) throws EventHandlerRegisterException {
        Class<T> eventType = GenericEventManagerImpl.getEventType(eventHandler);
        if (!Event.class.isAssignableFrom(eventType)) {
            GenericEventManagerImpl.registerCTEventHandler(eventHandler, eventType, priority, receiveCanceled);
        } else {
            GenericEventManagerImpl.registerNativeEventHandler(eventHandler, eventType.asSubclass(Event.class), priority, receiveCanceled);
        }
    }

    private static <T> void registerCTEventHandler(IEventHandler<T> eventHandler, Class<T> typeOfT, EventPriority priority, boolean receiveCanceled) throws EventHandlerRegisterException {
        Event forgeEvent;
        Class<T> implementationClass = typeOfT.isInterface() ? GenericEventManagerImpl.findImplementationClass(typeOfT) : typeOfT;
        Constructor<T> constructor = GenericEventManagerImpl.findProperCTEventConstructor(implementationClass);
        Class<?> forgeEventClass = constructor.getParameterTypes()[0];
        try {
            forgeEvent = (Event)forgeEventClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EventHandlerRegisterException("Failed to construct forge event", e);
        }
        try {
            CraftTweakerAPI.apply((IAction)new EventHandlerRegisterAction(new CTEventHandlerAdapter<T>(eventHandler, constructor, receiveCanceled), forgeEvent.getListenerList(), priority, 0, typeOfT.getSimpleName()));
        }
        catch (IllegalAccessException e) {
            throw new EventHandlerRegisterException("Event constructor is not public", e);
        }
    }

    private static <T extends Event> void registerNativeEventHandler(IEventHandler<T> eventHandler, Class<T> typeOfT, EventPriority priority, boolean receiveCanceled) throws EventHandlerRegisterException {
        Event forgeEvent;
        try {
            forgeEvent = (Event)typeOfT.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EventHandlerRegisterException("Failed to construct forge event", e);
        }
        CraftTweakerAPI.apply((IAction)new EventHandlerRegisterAction(new CTNativeEventHandlerAdapter<T>(eventHandler, receiveCanceled), forgeEvent.getListenerList(), priority, 0, typeOfT.getSimpleName()));
    }

    private static <T> Class<T> getEventType(IEventHandler<T> eventHandler) throws EventHandlerRegisterException {
        Type tType = InternalUtils.getSingleItfGenericVariable(eventHandler.getClass(), IEventHandler.class);
        if (tType instanceof Class) {
            return (Class)tType;
        }
        throw new EventHandlerRegisterException("The handler doesn't handle an actual event");
    }

    private static <T> Class<? extends T> findImplementationClass(Class<T> type) throws EventHandlerRegisterException {
        Set implementData = ZenUtils.asmDataTable.getAll(type.getTypeName().replace('.', '/'));
        if (implementData.size() == 1) {
            String implementClassName = ((ASMDataTable.ASMData)implementData.iterator().next()).getClassName().replace('/', '.');
            try {
                return Class.forName(implementClassName).asSubclass(type);
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new EventHandlerRegisterException("Forge said " + implementClassName + " implements " + type + ", but java doesn't think so.");
            }
        }
        for (ASMDataTable.ASMData asmData : implementData) {
            try {
                Class<?> clazz = Class.forName(asmData.getClassName().replace('/', '.'));
                if (clazz.isInterface() || clazz.getInterfaces().length != 1 || clazz.getInterfaces()[0] != type) continue;
                return clazz.asSubclass(type);
            }
            catch (ClassCastException | ClassNotFoundException exception) {
            }
        }
        throw new EventHandlerRegisterException("This event type doesn't have proper implementation class");
    }

    private static <T> Constructor<T> findProperCTEventConstructor(Class<T> ctEventClass) throws EventHandlerRegisterException {
        for (Constructor<?> constructor : ctEventClass.getConstructors()) {
            if (constructor.getParameterCount() != 1 || !Event.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
            return constructor;
        }
        throw new EventHandlerRegisterException("The implementation class doesn't have proper constructor");
    }

    static {
        try {
            EVENT_HANDLER_TYPE_VARIABLE = IEventHandler.class.getMethod("handle", Object.class).getGenericParameterTypes()[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class CTNativeEventHandlerAdapter<T extends Event>
    implements IEventListener {
        private final IEventHandler<T> handler;
        private final boolean receiveCanceled;

        public CTNativeEventHandlerAdapter(IEventHandler<T> handler, boolean receiveCanceled) {
            this.handler = handler;
            this.receiveCanceled = receiveCanceled;
        }

        public void invoke(Event event) {
            if (event.isCancelable() && event.isCanceled() && !this.receiveCanceled) {
                return;
            }
            try {
                this.handler.handle((Object)event);
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)"Exception occurred in the event handler", (Throwable)e);
            }
        }
    }

    private static class CTEventHandlerAdapter<T>
    implements IEventListener {
        private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
        private final IEventHandler<T> handler;
        private final MethodHandle ctEventBuilder;
        private final boolean receiveCanceled;

        public CTEventHandlerAdapter(IEventHandler<T> handler, Constructor<? extends T> ctEventBuilder, boolean receiveCanceled) throws IllegalAccessException {
            this.handler = handler;
            this.ctEventBuilder = LOOKUP.unreflectConstructor(ctEventBuilder);
            this.receiveCanceled = receiveCanceled;
        }

        public void invoke(Event event) {
            Object ctEvent;
            if (event.isCancelable() && event.isCanceled() && !this.receiveCanceled) {
                return;
            }
            try {
                ctEvent = this.ctEventBuilder.invoke(event);
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)"Failed to construct crt event", (Throwable)e);
                return;
            }
            try {
                this.handler.handle(ctEvent);
            }
            catch (Throwable e) {
                CraftTweakerAPI.logError((String)"Exception occurred in the event handler", (Throwable)e);
            }
        }
    }
}

