/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.zenscript;

import com.google.common.base.Preconditions;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.brackets.BracketHandlerBiome;
import crafttweaker.mc1120.brackets.BracketHandlerBiomeType;
import crafttweaker.mc1120.brackets.BracketHandlerBlockState;
import crafttweaker.mc1120.brackets.BracketHandlerCreativeTab;
import crafttweaker.mc1120.brackets.BracketHandlerDamageSource;
import crafttweaker.mc1120.brackets.BracketHandlerEnchantments;
import crafttweaker.mc1120.brackets.BracketHandlerEntity;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.brackets.BracketHandlerLiquid;
import crafttweaker.mc1120.brackets.BracketHandlerOre;
import crafttweaker.mc1120.brackets.BracketHandlerPotion;
import crafttweaker.mc1120.brackets.BracketHandlerPotionType;
import crafttweaker.zenscript.IBracketHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import youyihj.zenutils.impl.zenscript.TemplateString;

@ZenRegister
@BracketHandler
public class TemplateBracketHandler
implements IBracketHandler {
    private final Map<String, IJavaMethod> bracketMethods = new HashMap<String, IJavaMethod>();

    public TemplateBracketHandler() {
        this.initBracketHandlerMethods();
    }

    protected void initBracketHandlerMethods() {
        this.registerBracketHandlerMethod("item", CraftTweakerAPI.getJavaMethod(TemplateBracketHandler.class, (String)"getItem", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("biome", CraftTweakerAPI.getJavaMethod(BracketHandlerBiome.class, (String)"getBiome", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("biometypes", CraftTweakerAPI.getJavaMethod(BracketHandlerBiomeType.class, (String)"getBiomeType", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("blockstate", CraftTweakerAPI.getJavaMethod(TemplateBracketHandler.class, (String)"getBlockState", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("creativetab", CraftTweakerAPI.getJavaMethod(BracketHandlerCreativeTab.class, (String)"getTabFromString", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("damagesource", CraftTweakerAPI.getJavaMethod(BracketHandlerDamageSource.class, (String)"getFromString", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("enchantment", CraftTweakerAPI.getJavaMethod(BracketHandlerEnchantments.class, (String)"getEnchantment", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("entity", CraftTweakerAPI.getJavaMethod(BracketHandlerEntity.class, (String)"getEntity", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("liquid", CraftTweakerAPI.getJavaMethod(BracketHandlerLiquid.class, (String)"getLiquid", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("fluid", CraftTweakerAPI.getJavaMethod(BracketHandlerLiquid.class, (String)"getLiquid", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("ore", CraftTweakerAPI.getJavaMethod(BracketHandlerOre.class, (String)"getOre", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("potion", CraftTweakerAPI.getJavaMethod(BracketHandlerPotion.class, (String)"getPotion", (Class[])new Class[]{String.class}));
        this.registerBracketHandlerMethod("potiontype", CraftTweakerAPI.getJavaMethod(BracketHandlerPotionType.class, (String)"getFromString", (Class[])new Class[]{String.class}));
    }

    protected void registerBracketHandlerMethod(String prefix, IJavaMethod method) {
        Preconditions.checkArgument((boolean)Arrays.equals(method.getParameterTypes(), new ZenType[]{ZenType.STRING}));
        this.bracketMethods.put(prefix, method);
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        IJavaMethod method = this.bracketMethods.get(tokens.get(0).getValue().toLowerCase());
        if (method == null || tokens.get(1).getType() != 29) {
            return null;
        }
        List<Token> idTokens = tokens.subList(2, tokens.size());
        if (idTokens.stream().noneMatch(it -> it.getType() == 44)) {
            return null;
        }
        return position -> new ExpressionCallStatic(position, environment, method, new Expression[]{TemplateString.getExpression(idTokens, position, environment)});
    }

    public String getRegexMatchingString() {
        return this.bracketMethods.keySet().stream().collect(Collectors.joining("|", "(", ").*"));
    }

    public static IItemStack getItem(String name) {
        String[] split = name.split(":");
        if (split.length == 2) {
            return BracketHandlerItem.getItem((String)name, (int)0);
        }
        return BracketHandlerItem.getItem((String)name.substring(0, name.lastIndexOf(58)), (int)(split[2].equals("*") ? Short.MAX_VALUE : Integer.parseInt(split[2])));
    }

    public static IBlockState getBlockState(String expression) {
        String[] split = expression.split(":", 3);
        return BracketHandlerBlockState.getBlockState((String)(split[0] + ":" + split[1]), split.length == 3 ? split[2] : null);
    }
}

