/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util.catenation;

import com.google.common.base.Preconditions;
import crafttweaker.annotations.ZenRegister;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="mods.zenutils.CatenationTimer")
public class Timer {
    private final long duration;
    private long current;

    public Timer(long duration) {
        Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (Object)"duration must be positive.");
        this.duration = duration;
    }

    @ZenMethod
    public void update() {
        if (!this.isFinish()) {
            ++this.current;
        }
    }

    @ZenMethod
    public void reset() {
        this.setCurrent(0L);
    }

    @ZenGetter(value="current")
    public long getCurrent() {
        return this.current;
    }

    @ZenSetter(value="current")
    public void setCurrent(long current) {
        this.current = Math.min(this.duration, current);
    }

    @ZenGetter(value="duration")
    public long getDuration() {
        return this.duration;
    }

    @ZenGetter(value="finish")
    public boolean isFinish() {
        return this.current == this.duration;
    }
}

