/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.logger;

import crafttweaker.CraftTweakerAPI;
import java.util.HashSet;
import java.util.Set;
import youyihj.zenutils.api.logger.ILogFilter;
import youyihj.zenutils.api.logger.LogLevel;
import youyihj.zenutils.api.logger.ScriptPosition;

public class LogOption {
    private LogLevel minLogLevel = LogLevel.TRACE;
    private final Set<ILogFilter> filters = new HashSet<ILogFilter>();

    public LogLevel getMinLogLevel() {
        return this.minLogLevel;
    }

    public void setMinLogLevel(LogLevel minLogLevel) {
        this.minLogLevel = minLogLevel;
    }

    public void addFilter(ILogFilter filter) {
        this.filters.add(filter);
    }

    public boolean isBlock(LogLevel logLevel, String message) {
        this.fromCrTConfig();
        if (logLevel.compareTo(this.minLogLevel) < 0) {
            return true;
        }
        ScriptPosition scriptPosition = ScriptPosition.current();
        for (ILogFilter filter : this.filters) {
            if (!filter.isBlock(message, logLevel, scriptPosition)) continue;
            return true;
        }
        return false;
    }

    private void fromCrTConfig() {
        if (CraftTweakerAPI.isSuppressingErrors()) {
            this.minLogLevel = LogLevel.ERROR;
        } else if (CraftTweakerAPI.isSuppressingWarnings()) {
            this.minLogLevel = LogLevel.WARNING;
        }
    }
}

