/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.liquid;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.liquid.ILiquidTankProperties;
import youyihj.zenutils.impl.fluid.MCLiquidTankProperties;

@ZenClass(value="mods.zenutils.LiquidHandler")
@ZenRegister
public class CrTLiquidHandler {
    private final IFluidHandler fluidHandler;

    private CrTLiquidHandler(IFluidHandler itemHandler) {
        Objects.requireNonNull(itemHandler);
        this.fluidHandler = itemHandler;
    }

    public static CrTLiquidHandler of(IFluidHandler fluidHandler) {
        return fluidHandler == null ? null : new CrTLiquidHandler(fluidHandler);
    }

    @ZenGetter
    public List<ILiquidTankProperties> tankProperties() {
        return this.getLiquidTankProperties(this.fluidHandler.getTankProperties());
    }

    private List<ILiquidTankProperties> getLiquidTankProperties(IFluidTankProperties[] fluidTankProperties) {
        return Arrays.stream(fluidTankProperties).map(MCLiquidTankProperties::new).collect(Collectors.toList());
    }

    @ZenMethod
    public ILiquidStack drain(int maxDrain, boolean doDrain) {
        return CraftTweakerMC.getILiquidStack((FluidStack)this.fluidHandler.drain(maxDrain, doDrain));
    }

    @ZenMethod
    public ILiquidStack drain(ILiquidStack resource, boolean doDrain) {
        return CraftTweakerMC.getILiquidStack((FluidStack)this.fluidHandler.drain(CraftTweakerMC.getLiquidStack((ILiquidStack)resource), doDrain));
    }

    @ZenMethod
    public int fill(ILiquidStack resource, boolean doFill) {
        return this.fluidHandler.fill(CraftTweakerMC.getLiquidStack((ILiquidStack)resource), doFill);
    }
}

