/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.cotx.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.teamacronymcoders.base.registrysystem.BlockRegistry;
import com.teamacronymcoders.contenttweaker.ContentTweaker;
import com.teamacronymcoders.contenttweaker.api.ctobjects.blockmaterial.IBlockMaterialDefinition;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import stanhebben.zenscript.annotations.ZenClass;
import youyihj.zenutils.api.cotx.block.DirectionalBlockContent;
import youyihj.zenutils.api.cotx.block.ExpandBlockRepresentation;
import youyihj.zenutils.api.zenscript.SidedZenRegister;

@SidedZenRegister(modDeps={"contenttweaker"})
@ZenClass(value="mods.zenutils.cotx.DirectionalBlock")
public class DirectionalBlockRepresentation
extends ExpandBlockRepresentation {
    private final Directions directions;
    private final boolean planeRotatable;
    private final boolean placingOpposite;

    public DirectionalBlockRepresentation(String unlocalizedName, IBlockMaterialDefinition blockMaterial, Directions directions, boolean planeRotatable, boolean placingOpposite) {
        super(unlocalizedName, blockMaterial);
        this.directions = directions;
        this.planeRotatable = planeRotatable;
        this.placingOpposite = placingOpposite;
    }

    public Directions getDirections() {
        return this.directions;
    }

    public boolean isPlaneRotatable() {
        return this.planeRotatable;
    }

    public boolean isPlacingOpposite() {
        return this.placingOpposite;
    }

    @Override
    public void register() {
        ((BlockRegistry)ContentTweaker.instance.getRegistry(BlockRegistry.class, "BLOCK")).register((Block)DirectionalBlockContent.create(this));
    }

    public static enum PlaneRotation implements IStringSerializable
    {
        DOWN,
        UP,
        LEFT,
        RIGHT;

        private static final PlaneRotation[] VALUES;

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public PlaneRotation rotateClockWise90() {
            switch (this) {
                case DOWN: {
                    return LEFT;
                }
                case UP: {
                    return RIGHT;
                }
                case LEFT: {
                    return UP;
                }
                case RIGHT: {
                    return DOWN;
                }
            }
            return this;
        }

        public static PlaneRotation indexOf(int index) {
            return VALUES[index];
        }

        static {
            VALUES = PlaneRotation.values();
        }
    }

    public static enum Directions {
        ALL(EnumFacing.values()),
        HORIZONTAL(EnumFacing.Plane.HORIZONTAL.func_179516_a()),
        VERTICAL(EnumFacing.Plane.VERTICAL.func_179516_a());

        private final BiMap<EnumFacing, Integer> metaFacingMapping = EnumHashBiMap.create(EnumFacing.class);
        private final IProperty<EnumFacing> blockProperty;
        private final EnumFacing[] validFacings;

        private Directions(EnumFacing[] validFacings) {
            this.validFacings = validFacings;
            this.blockProperty = PropertyEnum.func_177706_a((String)"facing", EnumFacing.class, (Enum[])validFacings);
            this.fillMetaMapping();
        }

        public EnumFacing[] getValidFacings() {
            return this.validFacings;
        }

        public IProperty<EnumFacing> getBlockProperty() {
            return this.blockProperty;
        }

        public int toMeta(IBlockState state, boolean planeRotatable) {
            int facingMeta = (Integer)this.metaFacingMapping.get((Object)state.func_177229_b(this.blockProperty));
            if (planeRotatable) {
                return facingMeta * 4 + ((PlaneRotation)((Object)state.func_177229_b(DirectionalBlockContent.PLANE_ROTATION_PROPERTY))).ordinal();
            }
            return facingMeta;
        }

        public IBlockState toState(int meta, IBlockState defaultState, boolean planeRotatable) {
            if (planeRotatable) {
                return defaultState.func_177226_a(this.blockProperty, (Comparable)this.metaFacingMapping.inverse().get((Object)(meta / 4))).func_177226_a(DirectionalBlockContent.PLANE_ROTATION_PROPERTY, (Comparable)((Object)PlaneRotation.indexOf(meta % 4)));
            }
            return defaultState.func_177226_a(this.blockProperty, (Comparable)this.metaFacingMapping.inverse().get((Object)meta));
        }

        private void fillMetaMapping() {
            for (int i = 0; i < this.validFacings.length; ++i) {
                this.metaFacingMapping.put((Object)this.validFacings[i], (Object)i);
            }
        }
    }
}

