/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.dirt.block;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.phys.BlockHitResult;

public class TerraformGrassBlock
extends GrassBlock {
    private final Block dirt;
    private final Map<Block, Block> spreadsTo;
    private final Supplier<Block> path;
    public static final Map<Block, Block> GRASS_SPREADS_TO = new HashMap<Block, Block>();

    public TerraformGrassBlock(Block dirt, Supplier<Block> path, BlockBehaviour.Properties settings) {
        this(dirt, path, settings, (Map<Block, Block>)ImmutableMap.of((Object)Blocks.f_50493_, (Object)Blocks.f_50440_));
    }

    public TerraformGrassBlock(Block dirt, Supplier<Block> path, BlockBehaviour.Properties settings, Map<Block, Block> spreadsTo) {
        this(dirt, path, settings, spreadsTo, true);
    }

    public TerraformGrassBlock(Block dirt, Supplier<Block> path, BlockBehaviour.Properties settings, Map<Block, Block> spreadsTo, boolean grassSpreadsTo) {
        super(settings);
        this.dirt = dirt;
        this.spreadsTo = spreadsTo;
        this.path = path;
        if (grassSpreadsTo) {
            GRASS_SPREADS_TO.put(dirt, (Block)this);
        }
    }

    private static boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        BlockState aboveState = world.m_8055_(above);
        if (aboveState.m_60734_() == Blocks.f_50125_ && (Integer)aboveState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        int lightingAt = LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)aboveState, (BlockPos)above, (Direction)Direction.UP, (int)aboveState.m_60739_((BlockGetter)world, above));
        return lightingAt < world.m_7469_();
    }

    public static boolean canSpread(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        return TerraformGrassBlock.canSurvive(state, world, pos) && !world.m_6425_(above).m_205070_(FluidTags.f_13131_);
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!world.f_46443_) {
            if (!TerraformGrassBlock.canSurvive(state, (LevelReader)world, pos)) {
                world.m_46597_(pos, this.dirt.m_49966_());
            } else if (world.m_45517_(LightLayer.SKY, pos.m_7494_()) >= 4 && world.m_45517_(LightLayer.SKY, pos.m_7494_()) >= 9) {
                BlockState defaultState = this.m_49966_();
                for (int int_1 = 0; int_1 < 4; ++int_1) {
                    Block spreadedBlock;
                    BlockPos spreadingPos = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    Block spreadTarget = world.m_8055_(spreadingPos).m_60734_();
                    if (spreadTarget == this.dirt && TerraformGrassBlock.canSpread(defaultState, (LevelReader)world, spreadingPos)) {
                        world.m_46597_(spreadingPos, (BlockState)defaultState.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(world.m_8055_(spreadingPos.m_7494_()).m_60734_() == Blocks.f_50125_)));
                    }
                    if ((spreadedBlock = this.spreadsTo.get(spreadTarget)) == null || !TerraformGrassBlock.canSpread(defaultState, (LevelReader)world, spreadingPos)) continue;
                    BlockState spreadedState = spreadedBlock.m_49966_();
                    if (spreadedBlock instanceof SnowyDirtBlock) {
                        spreadedState = (BlockState)spreadedState.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(world.m_8055_(spreadingPos.m_7494_()).m_60734_() == Blocks.f_50125_));
                    }
                    world.m_46597_(spreadingPos, spreadedState);
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_6844_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        if (heldStack.m_41619_()) {
            return InteractionResult.FAIL;
        }
        Item held = heldStack.m_41720_();
        if (!(held instanceof DiggerItem)) {
            return InteractionResult.FAIL;
        }
        DiggerItem tool = (DiggerItem)held;
        if (hit.m_82434_() == Direction.DOWN || !world.m_8055_(pos.m_7494_()).m_60795_()) {
            return InteractionResult.FAIL;
        }
        if (this.path != null && (tool.m_8102_(heldStack, state) > 1.0f || tool instanceof ShovelItem)) {
            world.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                world.m_46597_(pos, this.path.get().m_49966_());
                heldStack.m_41622_(1, (LivingEntity)player, consumedPlayer -> consumedPlayer.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

