/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.dirt;

import com.terraformersmc.terraform.dirt.DirtBlocks;
import com.terraformersmc.terraform.dirt.TillableBlockRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TerraformDirtRegistry {
    private static final List<DirtBlocks> TYPES = new ArrayList<DirtBlocks>();
    private static final Map<Block, DirtBlocks> BY_GRASS_BLOCK = new HashMap<Block, DirtBlocks>();
    private static final Map<Block, DirtBlocks> BY_FARMLAND = new HashMap<Block, DirtBlocks>();

    public static DirtBlocks register(DirtBlocks blocks) {
        Objects.requireNonNull(blocks);
        TYPES.add(blocks);
        BY_GRASS_BLOCK.put((Block)blocks.getGrassBlock(), blocks);
        BY_FARMLAND.put((Block)blocks.getFarmland(), blocks);
        TillableBlockRegistry.add(blocks.getDirt(), blocks.getFarmland().m_49966_());
        TillableBlockRegistry.add((Block)blocks.getGrassBlock(), blocks.getFarmland().m_49966_());
        TillableBlockRegistry.add((Block)blocks.getDirtPath(), blocks.getFarmland().m_49966_());
        return blocks;
    }

    public static Optional<DirtBlocks> getFromWorld(LevelSimulatedReader world, BlockPos pos) {
        for (DirtBlocks blocks : TYPES) {
            Predicate<BlockState> isDirtLike = state -> state.m_60734_() == blocks.getDirt() || state.m_60734_() == blocks.getGrassBlock() || state.m_60734_() == blocks.getPodzol();
            if (!world.m_7433_(pos, isDirtLike)) continue;
            return Optional.of(blocks);
        }
        return Optional.empty();
    }

    public static Optional<DirtBlocks> getByGrassBlock(Block grass) {
        return Optional.ofNullable(BY_GRASS_BLOCK.get(grass));
    }

    public static Optional<DirtBlocks> getByFarmland(Block farmland) {
        return Optional.ofNullable(BY_FARMLAND.get(farmland));
    }
}

