/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.terraformersmc.terraform.config.BiomeConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class BiomeConfigHandler {
    private String namespace;
    private File file;
    private BiomeConfig config;

    public BiomeConfigHandler(String namespace) {
        this.namespace = namespace;
    }

    private void prepareBiomeConfigFile() {
        if (this.file != null) {
            return;
        }
        File configDirectory = new File(".", "config/" + this.namespace);
        this.file = new File(configDirectory, "biomes.json");
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
    }

    public BiomeConfig getBiomeConfig() {
        return this.getBiomeConfig(false);
    }

    public BiomeConfig getBiomeConfig(boolean defaultFreeze) {
        if (this.config != null) {
            return this.config;
        }
        this.config = new BiomeConfig(defaultFreeze);
        this.load();
        return this.config;
    }

    private void load() {
        this.prepareBiomeConfigFile();
        try {
            if (this.file.exists()) {
                Gson gson = new Gson();
                BufferedReader br = new BufferedReader(new FileReader(this.file));
                this.config = (BiomeConfig)gson.fromJson((Reader)br, BiomeConfig.class);
            }
        }
        catch (Exception e) {
            System.err.println("Couldn't load biome configuration file for " + this.namespace + ", reverting to defaults");
            e.printStackTrace();
        }
    }

    public void save() {
        this.prepareBiomeConfigFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((Object)this.config);
        try (FileWriter fileWriter = new FileWriter(this.file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save biome configuration file for " + this.namespace);
            e.printStackTrace();
        }
    }
}

